/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.healthcheck.events.InstanceHeartbeatTimeoutEvent;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingProxy;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.PushService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.util.List;

public class ClientBeatCheckTask
implements Runnable {
    private Service service;

    public ClientBeatCheckTask(Service service) {
        this.service = service;
    }

    @JsonIgnore
    public PushService getPushService() {
        return (PushService)ApplicationUtils.getBean(PushService.class);
    }

    @JsonIgnore
    public DistroMapper getDistroMapper() {
        return (DistroMapper)ApplicationUtils.getBean(DistroMapper.class);
    }

    public GlobalConfig getGlobalConfig() {
        return (GlobalConfig)ApplicationUtils.getBean(GlobalConfig.class);
    }

    public SwitchDomain getSwitchDomain() {
        return (SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class);
    }

    public String taskKey() {
        return KeyBuilder.buildServiceMetaKey(this.service.getNamespaceId(), this.service.getName());
    }

    @Override
    public void run() {
        try {
            if (!this.getDistroMapper().responsible(this.service.getName())) {
                return;
            }
            if (!this.getSwitchDomain().isHealthCheckEnabled()) {
                return;
            }
            List<Instance> instances = this.service.allIPs(true);
            for (Instance instance : instances) {
                if (System.currentTimeMillis() - instance.getLastBeat() <= instance.getInstanceHeartBeatTimeOut() || instance.isMarked() || !instance.isHealthy()) continue;
                instance.setHealthy(false);
                Loggers.EVT_LOG.info("{POS} {IP-DISABLED} valid: {}:{}@{}@{}, region: {}, msg: client timeout after {}, last beat: {}", new Object[]{instance.getIp(), instance.getPort(), instance.getClusterName(), this.service.getName(), "unknown", instance.getInstanceHeartBeatTimeOut(), instance.getLastBeat()});
                this.getPushService().serviceChanged(this.service);
                ApplicationUtils.publishEvent((Object)((Object)new InstanceHeartbeatTimeoutEvent(this, instance)));
            }
            if (!this.getGlobalConfig().isExpireInstance()) {
                return;
            }
            for (Instance instance : instances) {
                if (instance.isMarked() || System.currentTimeMillis() - instance.getLastBeat() <= instance.getIpDeleteTimeout()) continue;
                Loggers.SRV_LOG.info("[AUTO-DELETE-IP] service: {}, ip: {}", (Object)this.service.getName(), (Object)JacksonUtils.toJson((Object)instance));
                this.deleteIp(instance);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("Exception while processing client beat time out.", (Throwable)e);
        }
    }

    private void deleteIp(final Instance instance) {
        try {
            NamingProxy.Request request = NamingProxy.Request.newRequest();
            request.appendParam("ip", instance.getIp()).appendParam("port", String.valueOf(instance.getPort())).appendParam("ephemeral", "true").appendParam("clusterName", instance.getClusterName()).appendParam("serviceName", this.service.getName()).appendParam("namespaceId", this.service.getNamespaceId());
            String url = "http://127.0.0.1:" + ApplicationUtils.getPort() + ApplicationUtils.getContextPath() + "/v1/ns" + "/instance?" + request.toUrl();
            HttpClient.asyncHttpDelete(url, null, null, new AsyncCompletionHandler(){

                public Object onCompleted(Response response) throws Exception {
                    if (response.getStatusCode() != 200) {
                        Loggers.SRV_LOG.error("[IP-DEAD] failed to delete ip automatically, ip: {}, caused {}, resp code: {}", new Object[]{instance.toJson(), response.getResponseBody(), response.getStatusCode()});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Loggers.SRV_LOG.error("[IP-DEAD] failed to delete ip automatically, ip: {}, error: {}", (Object)instance.toJson(), (Object)e);
        }
    }
}

