/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.notify.NotifyCenter;
import com.alibaba.nacos.core.notify.listener.Subscribe;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.consistency.persistent.raft.LeaderElectFinishedEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.MakeLeaderEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.bag.TreeBag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"ProtocolManager"})
public class RaftPeerSet
implements MemberChangeListener {
    private final ServerMemberManager memberManager;
    private AtomicLong localTerm = new AtomicLong(0L);
    private RaftPeer leader = null;
    private volatile Map<String, RaftPeer> peers = new HashMap<String, RaftPeer>(8);
    private Set<String> sites = new HashSet<String>();
    private volatile boolean ready = false;
    private Set<Member> oldMembers;

    public RaftPeerSet(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @PostConstruct
    public void init() {
        NotifyCenter.registerSubscribe((Subscribe)this);
        this.changePeers(this.memberManager.allMembers());
    }

    public RaftPeer getLeader() {
        if (ApplicationUtils.getStandaloneMode()) {
            return this.local();
        }
        return this.leader;
    }

    public Set<String> allSites() {
        return this.sites;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void remove(List<String> servers) {
        for (String server : servers) {
            this.peers.remove(server);
        }
    }

    public RaftPeer update(RaftPeer peer) {
        this.peers.put(peer.ip, peer);
        return peer;
    }

    public boolean isLeader(String ip) {
        if (ApplicationUtils.getStandaloneMode()) {
            return true;
        }
        if (this.leader == null) {
            Loggers.RAFT.warn("[IS LEADER] no leader is available now!");
            return false;
        }
        return StringUtils.equals((CharSequence)this.leader.ip, (CharSequence)ip);
    }

    public Set<String> allServersIncludeMyself() {
        return this.peers.keySet();
    }

    public Set<String> allServersWithoutMySelf() {
        HashSet<String> servers = new HashSet<String>(this.peers.keySet());
        servers.remove(this.local().ip);
        return servers;
    }

    public Collection<RaftPeer> allPeers() {
        return this.peers.values();
    }

    public int size() {
        return this.peers.size();
    }

    public RaftPeer decideLeader(RaftPeer candidate) {
        this.peers.put(candidate.ip, candidate);
        TreeBag ips = new TreeBag();
        int maxApproveCount = 0;
        String maxApprovePeer = null;
        for (RaftPeer peer : this.peers.values()) {
            if (StringUtils.isEmpty((CharSequence)peer.voteFor)) continue;
            ips.add((Object)peer.voteFor);
            if (ips.getCount((Object)peer.voteFor) <= maxApproveCount) continue;
            maxApproveCount = ips.getCount((Object)peer.voteFor);
            maxApprovePeer = peer.voteFor;
        }
        if (maxApproveCount >= this.majorityCount()) {
            RaftPeer peer = this.peers.get(maxApprovePeer);
            peer.state = RaftPeer.State.LEADER;
            if (!Objects.equals(this.leader, peer)) {
                this.leader = peer;
                ApplicationUtils.publishEvent((Object)((Object)new LeaderElectFinishedEvent(this, this.leader, this.local())));
                Loggers.RAFT.info("{} has become the LEADER", (Object)this.leader.ip);
            }
        }
        return this.leader;
    }

    public RaftPeer makeLeader(RaftPeer candidate) {
        if (!Objects.equals(this.leader, candidate)) {
            this.leader = candidate;
            ApplicationUtils.publishEvent((Object)((Object)new MakeLeaderEvent(this, this.leader, this.local())));
            Loggers.RAFT.info("{} has become the LEADER, local: {}, leader: {}", new Object[]{this.leader.ip, JacksonUtils.toJson((Object)this.local()), JacksonUtils.toJson((Object)this.leader)});
        }
        for (final RaftPeer peer : this.peers.values()) {
            HashMap<String, String> params = new HashMap<String, String>(1);
            if (Objects.equals(peer, candidate) || peer.state != RaftPeer.State.LEADER) continue;
            try {
                String url = RaftCore.buildUrl(peer.ip, "/v1/ns/raft/peer");
                HttpClient.asyncHttpGet(url, null, params, (AsyncCompletionHandler)new AsyncCompletionHandler<Integer>(){

                    public Integer onCompleted(Response response) throws Exception {
                        if (response.getStatusCode() != 200) {
                            Loggers.RAFT.error("[NACOS-RAFT] get peer failed: {}, peer: {}", (Object)response.getResponseBody(), (Object)peer.ip);
                            peer.state = RaftPeer.State.FOLLOWER;
                            return 1;
                        }
                        RaftPeerSet.this.update((RaftPeer)JacksonUtils.toObj((String)response.getResponseBody(), RaftPeer.class));
                        return 0;
                    }
                });
            }
            catch (Exception e) {
                peer.state = RaftPeer.State.FOLLOWER;
                Loggers.RAFT.error("[NACOS-RAFT] error while getting peer from peer: {}", (Object)peer.ip);
            }
        }
        return this.update(candidate);
    }

    public RaftPeer local() {
        RaftPeer peer = this.peers.get(ApplicationUtils.getLocalAddress());
        if (peer == null && ApplicationUtils.getStandaloneMode()) {
            RaftPeer localPeer = new RaftPeer();
            localPeer.ip = NetUtils.localServer();
            localPeer.term.set(this.localTerm.get());
            this.peers.put(localPeer.ip, localPeer);
            return localPeer;
        }
        if (peer == null) {
            throw new IllegalStateException("unable to find local peer: " + NetUtils.localServer() + ", all peers: " + Arrays.toString(this.peers.keySet().toArray()));
        }
        return peer;
    }

    public RaftPeer get(String server) {
        return this.peers.get(server);
    }

    public int majorityCount() {
        return this.peers.size() / 2 + 1;
    }

    public void reset() {
        this.leader = null;
        for (RaftPeer peer : this.peers.values()) {
            peer.voteFor = null;
        }
    }

    public void setTerm(long term) {
        this.localTerm.set(term);
    }

    public long getTerm() {
        return this.localTerm.get();
    }

    public boolean contains(RaftPeer remote) {
        return this.peers.containsKey(remote.ip);
    }

    public void onEvent(MembersChangeEvent event) {
        Collection members = event.getMembers();
        if (this.oldMembers == null) {
            this.oldMembers = new HashSet<Member>(members);
        } else {
            this.oldMembers.removeAll(members);
        }
        if (!this.oldMembers.isEmpty()) {
            this.changePeers(members);
        }
        this.oldMembers.clear();
        this.oldMembers.addAll(members);
    }

    private void changePeers(Collection<Member> members) {
        HashMap<String, RaftPeer> tmpPeers = new HashMap<String, RaftPeer>(members.size());
        for (Member member : members) {
            String address = member.getAddress();
            if (this.peers.containsKey(address)) {
                tmpPeers.put(address, this.peers.get(address));
                continue;
            }
            RaftPeer raftPeer = new RaftPeer();
            raftPeer.ip = address;
            if (ApplicationUtils.getLocalAddress().equals(address)) {
                raftPeer.term.set(this.localTerm.get());
            }
            tmpPeers.put(address, raftPeer);
        }
        this.peers = tmpPeers;
        this.ready = true;
        Loggers.RAFT.info("raft peers changed: " + members);
    }

    public String toString() {
        return "RaftPeerSet{localTerm=" + this.localTerm + ", leader=" + this.leader + ", peers=" + this.peers + ", sites=" + this.sites + '}';
    }
}

