/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.consistency.persistent.raft.BaseRaftEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RaftListener
implements SmartApplicationListener {
    private static final String GROUP = "naming";
    @Autowired
    private ServerMemberManager memberManager;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        boolean a = BaseRaftEvent.class.isAssignableFrom(eventType);
        return a;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof BaseRaftEvent) {
            BaseRaftEvent raftEvent = (BaseRaftEvent)event;
            RaftPeer local = raftEvent.getLocal();
            String json = JacksonUtils.toJson((Object)local);
            Map map = (Map)JacksonUtils.toObj((String)json, HashMap.class);
            Member self = this.memberManager.getSelf();
            self.setExtendVal(GROUP, (Object)map);
            this.memberManager.update(self);
        }
    }
}

