/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.PersistentConsistencyService;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeerSet;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"ProtocolManager"})
@Service
public class RaftConsistencyServiceImpl
implements PersistentConsistencyService {
    @Autowired
    private RaftCore raftCore;
    @Autowired
    private RaftPeerSet peers;
    @Autowired
    private SwitchDomain switchDomain;

    @Override
    public void put(String key, Record value) throws NacosException {
        try {
            this.raftCore.signalPublish(key, value);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft put failed.", (Throwable)e);
            throw new NacosException(500, "Raft put failed, key:" + key + ", value:" + value, (Throwable)e);
        }
    }

    @Override
    public void remove(String key) throws NacosException {
        try {
            if (KeyBuilder.matchInstanceListKey(key) && !this.raftCore.isLeader()) {
                Datum datum = new Datum();
                datum.key = key;
                this.raftCore.onDelete(datum.key, this.peers.getLeader());
                this.raftCore.unlistenAll(key);
                return;
            }
            this.raftCore.signalDelete(key);
            this.raftCore.unlistenAll(key);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft remove failed.", (Throwable)e);
            throw new NacosException(500, "Raft remove failed, key:" + key, (Throwable)e);
        }
    }

    @Override
    public Datum get(String key) throws NacosException {
        return this.raftCore.getDatum(key);
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        this.raftCore.listen(key, listener);
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.raftCore.unListen(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return this.raftCore.isInitialized() || ServerStatus.UP.name().equals(this.switchDomain.getOverriddenServerStatus());
    }

    public void onPut(Datum datum, RaftPeer source) throws NacosException {
        try {
            this.raftCore.onPublish(datum, source);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft onPut failed.", (Throwable)e);
            throw new NacosException(500, "Raft onPut failed, datum:" + datum + ", source: " + source, (Throwable)e);
        }
    }

    public void onRemove(Datum datum, RaftPeer source) throws NacosException {
        try {
            this.raftCore.onDelete(datum.key, source);
        }
        catch (Exception e) {
            Loggers.RAFT.error("Raft onRemove failed.", (Throwable)e);
            throw new NacosException(500, "Raft onRemove failed, datum:" + datum + ", source: " + source, (Throwable)e);
        }
    }
}

