/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class StringPool {
    private static Cache<String, String> groupKeyCache = CacheBuilder.newBuilder().maximumSize(5000000L).expireAfterAccess(180L, TimeUnit.SECONDS).build();

    public static String get(String key) {
        if (key == null) {
            return key;
        }
        String value = (String)groupKeyCache.getIfPresent((Object)key);
        if (value == null) {
            groupKeyCache.put((Object)key, (Object)key);
            value = (String)groupKeyCache.getIfPresent((Object)key);
        }
        return value;
    }

    public static long size() {
        return groupKeyCache.size();
    }

    public static void remove(String key) {
        groupKeyCache.invalidate((Object)key);
    }
}

