/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.grpc.auto.BiRequestStreamGrpc;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.ConnectionSetupRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.core.remote.RpcAckCallbackSynchronizer;
import com.alibaba.nacos.core.remote.grpc.BaseGrpcServer;
import com.alibaba.nacos.core.remote.grpc.GrpcConnection;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrpcBiStreamRequestAcceptor
extends BiRequestStreamGrpc.BiRequestStreamImplBase {
    @Autowired
    ConnectionManager connectionManager;

    private void traceDetailIfNecessary(Payload grpcRequest) {
        String clientIp = grpcRequest.getMetadata().getClientIp();
        String connectionId = (String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get();
        try {
            if (this.connectionManager.traced(clientIp)) {
                Loggers.REMOTE_DIGEST.info("[{}]Bi stream request receive, meta={},body={}", new Object[]{connectionId, grpcRequest.getMetadata().toByteString().toStringUtf8(), grpcRequest.getBody().toByteString().toStringUtf8()});
            }
        }
        catch (Throwable throwable) {
            Loggers.REMOTE_DIGEST.error("[{}]Bi stream request error,payload={},error={}", new Object[]{connectionId, grpcRequest.toByteString().toStringUtf8(), throwable});
        }
    }

    public StreamObserver<Payload> requestBiStream(final StreamObserver<Payload> responseObserver) {
        StreamObserver<Payload> streamObserver = new StreamObserver<Payload>(){
            final String connectionId = (String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get();
            final Integer localPort = (Integer)BaseGrpcServer.CONTEXT_KEY_CONN_LOCAL_PORT.get();
            final int remotePort = (Integer)BaseGrpcServer.CONTEXT_KEY_CONN_REMOTE_PORT.get();
            String remoteIp = (String)BaseGrpcServer.CONTEXT_KEY_CONN_REMOTE_IP.get();
            String clientIp = "";

            public void onNext(Payload payload) {
                this.clientIp = payload.getMetadata().getClientIp();
                GrpcBiStreamRequestAcceptor.this.traceDetailIfNecessary(payload);
                Object parseObj = null;
                try {
                    parseObj = GrpcUtils.parse((Payload)payload);
                }
                catch (Throwable throwable) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,payload parse error={}", (Object)this.connectionId, (Object)throwable);
                    return;
                }
                if (parseObj == null) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,payload parse null ,body={},meta={}", new Object[]{this.connectionId, payload.getBody().getValue().toStringUtf8(), payload.getMetadata()});
                    return;
                }
                if (parseObj instanceof ConnectionSetupRequest) {
                    boolean rejectSdkOnStarting;
                    ConnectionSetupRequest setUpRequest = (ConnectionSetupRequest)parseObj;
                    Map labels = setUpRequest.getLabels();
                    String appName = "-";
                    if (labels != null && labels.containsKey("AppName")) {
                        appName = (String)labels.get("AppName");
                    }
                    ConnectionMeta metaInfo = new ConnectionMeta(this.connectionId, payload.getMetadata().getClientIp(), this.remoteIp, this.remotePort, this.localPort, ConnectionType.GRPC.getType(), setUpRequest.getClientVersion(), appName, setUpRequest.getLabels());
                    metaInfo.setTenant(setUpRequest.getTenant());
                    GrpcConnection connection = new GrpcConnection(metaInfo, responseObserver, (Channel)BaseGrpcServer.CONTEXT_KEY_CHANNEL.get());
                    connection.setAbilities(setUpRequest.getAbilities());
                    boolean bl = rejectSdkOnStarting = metaInfo.isSdkSource() && !ApplicationUtils.isStarted();
                    if (rejectSdkOnStarting || !GrpcBiStreamRequestAcceptor.this.connectionManager.register(this.connectionId, connection)) {
                        block12: {
                            try {
                                Loggers.REMOTE_DIGEST.warn("[{}]Connection register fail,reason:{}", (Object)this.connectionId, (Object)(rejectSdkOnStarting ? " server is not started" : " server is over limited."));
                                connection.request((Request)new ConnectResetRequest(), 3000L);
                                connection.close();
                            }
                            catch (Exception e) {
                                if (!GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) break block12;
                                Loggers.REMOTE_DIGEST.warn("[{}]Send connect reset request error,error={}", (Object)this.connectionId, (Object)e);
                            }
                        }
                        return;
                    }
                } else if (parseObj != null && parseObj instanceof Response) {
                    Response response = (Response)parseObj;
                    if (GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) {
                        Loggers.REMOTE_DIGEST.warn("[{}]Receive response of server request  ,response={}", (Object)this.connectionId, (Object)response);
                    }
                    RpcAckCallbackSynchronizer.ackNotify(this.connectionId, response);
                    GrpcBiStreamRequestAcceptor.this.connectionManager.refreshActiveTime(this.connectionId);
                } else {
                    Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,unknown payload receive ,parseObj={}", (Object)this.connectionId, parseObj);
                    return;
                }
            }

            public void onError(Throwable t) {
                if (GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Bi stream on error,error={}", (Object)this.connectionId, (Object)t);
                }
                if (responseObserver instanceof ServerCallStreamObserver) {
                    ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
                    if (serverCallStreamObserver.isCancelled()) {
                        return;
                    }
                    serverCallStreamObserver.onCompleted();
                }
            }

            public void onCompleted() {
                if (GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Bi stream on completed", (Object)this.connectionId);
                }
                if (responseObserver instanceof ServerCallStreamObserver) {
                    ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
                    if (serverCallStreamObserver.isCancelled()) {
                        return;
                    }
                    serverCallStreamObserver.onCompleted();
                }
            }
        };
        return streamObserver;
    }
}

