/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.control;

import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.core.remote.control.MonitorKey;
import com.alibaba.nacos.core.remote.control.MonitorKeyMatcher;
import com.alibaba.nacos.core.remote.control.TpsControlRule;
import com.alibaba.nacos.core.remote.control.TpsRecorder;
import com.alibaba.nacos.core.utils.Loggers;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TpsMonitorPoint {
    public static final int DEFAULT_RECORD_SIZE = 10;
    private long startTime;
    private String pointName;
    private TpsRecorder tpsRecorder;
    public Map<String, TpsRecorder> monitorKeysRecorder = new HashMap<String, TpsRecorder>();

    public TpsMonitorPoint(String pointName) {
        this(pointName, -1, "monitor");
    }

    public TpsMonitorPoint(String pointName, int maxTps, String monitorType) {
        this.startTime = TpsMonitorPoint.getTrimMillsOfSecond(System.currentTimeMillis());
        this.pointName = pointName;
        this.tpsRecorder = new TpsRecorder(this.startTime, TimeUnit.SECONDS, "FUZZY", 10);
        this.tpsRecorder.setMaxCount(maxTps);
        this.tpsRecorder.setMonitorType(monitorType);
    }

    public static long getTrimMillsOfSecond(long timeStamp) {
        String millString = String.valueOf(timeStamp);
        String substring = millString.substring(0, millString.length() - 3);
        return Long.valueOf(substring + "000");
    }

    public static long getTrimMillsOfMinute(long timeStamp) {
        String millString = String.valueOf(timeStamp);
        String substring = millString.substring(0, millString.length() - 3);
        return Long.valueOf(Long.valueOf(substring) / 60L * 60L + "000");
    }

    public static long getTrimMillsOfHour(long timeStamp) {
        String millString = String.valueOf(timeStamp);
        String substring = millString.substring(0, millString.length() - 3);
        return Long.valueOf(Long.valueOf(substring) / 3600L * 3600L + "000");
    }

    public static String getTimeFormatOfSecond(long timeStamp) {
        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeStamp));
        return format;
    }

    private void stopAllMonitorClient() {
        this.monitorKeysRecorder.clear();
    }

    public boolean applyTps(String connectionId, List<MonitorKey> monitorKeys) {
        boolean overLimit;
        long now = System.currentTimeMillis();
        TpsRecorder.TpsSlot currentTps = this.tpsRecorder.createSlotIfAbsent(now);
        ArrayList<TpsRecorder.SlotCountHolder> passedSlots = new ArrayList<TpsRecorder.SlotCountHolder>();
        for (MonitorKey monitorKey : monitorKeys) {
            for (Map.Entry<String, TpsRecorder> entry : this.monitorKeysRecorder.entrySet()) {
                boolean overLimit2;
                if (!MonitorKeyMatcher.matchWithType(entry.getKey(), monitorKey.build())) continue;
                TpsRecorder tpsRecorderKey = entry.getValue();
                TpsRecorder.TpsSlot currentKeySlot = tpsRecorderKey.createSlotIfAbsent(now);
                long maxTpsCount = tpsRecorderKey.getMaxCount();
                TpsRecorder.SlotCountHolder countHolder = currentKeySlot.getCountHolder(monitorKey.build());
                boolean bl = overLimit2 = maxTpsCount >= 0L && countHolder.count.longValue() >= maxTpsCount;
                if (overLimit2) {
                    Loggers.TPS_CONTROL_DETAIL.info("[{}]Tps over limit ,pointName=[{}],barrier=[{}]\uff0cmonitorModel={},maxTps={}", new Object[]{connectionId, this.getPointName(), entry.getKey(), tpsRecorderKey.getMonitorType(), maxTpsCount + "/" + (Object)((Object)tpsRecorderKey.period)});
                    if (!tpsRecorderKey.isInterceptMode()) continue;
                    currentKeySlot.getCountHolder((String)monitorKey.build()).interceptedCount.incrementAndGet();
                    currentTps.getCountHolder((String)monitorKey.build()).interceptedCount.incrementAndGet();
                    return false;
                }
                passedSlots.add(countHolder);
            }
        }
        long maxTps = this.tpsRecorder.getMaxCount();
        boolean bl = overLimit = maxTps >= 0L && currentTps.getCountHolder((String)this.pointName).count.longValue() >= maxTps;
        if (overLimit) {
            Loggers.TPS_CONTROL_DETAIL.info("[{}]Tps over limit ,pointName=[{}],barrier=[{}]\uff0cmonitorType={}", new Object[]{connectionId, this.getPointName(), "pointRule", this.tpsRecorder.getMonitorType()});
            if (this.tpsRecorder.isInterceptMode()) {
                currentTps.getCountHolder((String)this.pointName).interceptedCount.incrementAndGet();
                return false;
            }
        }
        currentTps.getCountHolder((String)this.pointName).count.incrementAndGet();
        for (TpsRecorder.SlotCountHolder passedTpsSlot : passedSlots) {
            passedTpsSlot.count.incrementAndGet();
        }
        return true;
    }

    public TpsRecorder getTpsRecorder() {
        return this.tpsRecorder;
    }

    public String getPointName() {
        return this.pointName;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public synchronized void applyRule(TpsControlRule newControlRule) {
        Loggers.TPS_CONTROL.info("Apply tps control rule parse start,pointName=[{}]  ", (Object)this.getPointName());
        if (newControlRule == null) {
            Loggers.TPS_CONTROL.info("Clear all tps control rule ,pointName=[{}]  ", (Object)this.getPointName());
            this.tpsRecorder.clearLimitRule();
            this.stopAllMonitorClient();
            return;
        }
        TpsControlRule.Rule newPointRule = newControlRule.getPointRule();
        if (newPointRule == null) {
            Loggers.TPS_CONTROL.info("Clear point  control rule ,pointName=[{}]  ", (Object)this.getPointName());
            this.tpsRecorder.clearLimitRule();
        } else {
            Loggers.TPS_CONTROL.info("Update  point  control rule ,pointName=[{}],original maxTps={}, new maxTps={},original monitorType={}, original monitorType={}, ", new Object[]{this.getPointName(), this.tpsRecorder.getMaxCount(), newPointRule.maxCount, this.tpsRecorder.getMonitorType(), newPointRule.monitorType});
            this.tpsRecorder.setMaxCount(newPointRule.maxCount);
            this.tpsRecorder.setMonitorType(newPointRule.monitorType);
        }
        Map<String, TpsControlRule.Rule> newMonitorKeyRules = newControlRule.getMonitorKeyRule();
        if (newMonitorKeyRules == null || newMonitorKeyRules.isEmpty()) {
            Loggers.TPS_CONTROL.info("Clear point  control rule for monitorKeys, pointName=[{}]  ", (Object)this.getPointName());
            this.stopAllMonitorClient();
        } else {
            Map<String, TpsRecorder> monitorKeysRecorderCurrent = this.monitorKeysRecorder;
            for (Map.Entry<String, TpsControlRule.Rule> newMonitorRule : newMonitorKeyRules.entrySet()) {
                boolean checkPattern;
                if (newMonitorRule.getValue() == null) continue;
                boolean bl = checkPattern = newMonitorRule.getKey() != null;
                if (!checkPattern) {
                    Loggers.TPS_CONTROL.info("Invalid monitor rule, pointName=[{}] ,monitorRule={} ,Ignore this.", (Object)this.getPointName(), (Object)newMonitorRule.getKey());
                    continue;
                }
                TpsControlRule.Rule newRule = newMonitorRule.getValue();
                if (newRule.period == null) {
                    newRule.period = TimeUnit.SECONDS;
                }
                if (newRule.model == null) {
                    newRule.model = "FUZZY";
                }
                if (monitorKeysRecorderCurrent.containsKey(newMonitorRule.getKey())) {
                    TpsRecorder tpsRecorder = monitorKeysRecorderCurrent.get(newMonitorRule.getKey());
                    Loggers.TPS_CONTROL.info("Update  point  control rule for client ip ,pointName=[{}],monitorKey=[{}],original maxTps={}, new maxTps={},original monitorType={}, new monitorType={}, ", new Object[]{this.getPointName(), newMonitorRule.getKey(), tpsRecorder.getMaxCount(), newRule.maxCount, tpsRecorder.getMonitorType(), newRule.monitorType});
                    if (!Objects.equals((Object)((Object)tpsRecorder.period), (Object)((Object)newRule.period)) || !Objects.equals((Object)tpsRecorder.getModel(), (Object)newRule.model)) {
                        TpsRecorder tpsRecorderNew = new TpsRecorder(this.startTime, newRule.period, newRule.model, 10);
                        tpsRecorderNew.setMaxCount(newRule.maxCount);
                        tpsRecorderNew.setMonitorType(newRule.monitorType);
                        monitorKeysRecorderCurrent.put(newMonitorRule.getKey(), tpsRecorderNew);
                        continue;
                    }
                    tpsRecorder.setMaxCount(newRule.maxCount);
                    tpsRecorder.setMonitorType(newRule.monitorType);
                    continue;
                }
                Loggers.TPS_CONTROL.info("Add  point  control rule for client ip ,pointName=[{}],monitorKey=[{}], new maxTps={}, new monitorType={}, ", new Object[]{this.getPointName(), newMonitorRule.getKey(), newMonitorRule.getValue().maxCount, newMonitorRule.getValue().monitorType});
                TpsRecorder tpsRecorderAdd = new TpsRecorder(this.startTime, newRule.period, newRule.model, 10);
                tpsRecorderAdd.setMaxCount(newRule.maxCount);
                tpsRecorderAdd.setMonitorType(newRule.monitorType);
                monitorKeysRecorderCurrent.put(newMonitorRule.getKey(), tpsRecorderAdd);
            }
            Iterator<Map.Entry<String, TpsRecorder>> iteratorCurrent = monitorKeysRecorderCurrent.entrySet().iterator();
            while (iteratorCurrent.hasNext()) {
                Map.Entry<String, TpsRecorder> next1 = iteratorCurrent.next();
                if (newMonitorKeyRules.containsKey(next1.getKey().toString())) continue;
                Loggers.TPS_CONTROL.info("Delete  point  control rule for pointName=[{}] ,monitorKey=[{}]", (Object)this.getPointName(), (Object)next1.getKey());
                iteratorCurrent.remove();
            }
        }
    }
}

