/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.control;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.control.ClientIpMonitorKey;
import com.alibaba.nacos.core.remote.control.MonitorKey;
import com.alibaba.nacos.core.remote.control.TpsControlRule;
import com.alibaba.nacos.core.remote.control.TpsControlRuleChangeEvent;
import com.alibaba.nacos.core.remote.control.TpsMonitorPoint;
import com.alibaba.nacos.core.remote.control.TpsRecorder;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import com.alibaba.nacos.sys.utils.DiskUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class TpsMonitorManager
extends Subscriber<TpsControlRuleChangeEvent> {
    public final Map<String, TpsMonitorPoint> points = new ConcurrentHashMap<String, TpsMonitorPoint>(16);
    private static ScheduledExecutorService executorService = ExecutorFactory.newSingleScheduledExecutorService(r -> {
        Thread thread = new Thread(r, "nacos.core.remote.tps.control.reporter");
        thread.setDaemon(true);
        return thread;
    });

    public TpsMonitorManager() {
        NotifyCenter.registerToPublisher(TpsControlRuleChangeEvent.class, (int)NotifyCenter.ringBufferSize);
        NotifyCenter.registerSubscriber((Subscriber)this);
        executorService.scheduleWithFixedDelay(new TpsMonitorReporter(), 0L, 900L, TimeUnit.MILLISECONDS);
        this.registerFileWatch();
    }

    public void registerTpsControlPoint(TpsMonitorPoint tpsMonitorPoint) {
        Loggers.TPS_CONTROL.info("Register tps control,pointName={}, point={} ", (Object)tpsMonitorPoint.getPointName(), (Object)tpsMonitorPoint);
        try {
            this.loadRuleFromLocal(tpsMonitorPoint);
        }
        catch (IOException e) {
            Loggers.TPS_CONTROL.error("Fail to init rule from local,pointName={},error={}", (Object)tpsMonitorPoint.getPointName(), (Object)e);
        }
        this.points.putIfAbsent(tpsMonitorPoint.getPointName(), tpsMonitorPoint);
    }

    private void registerFileWatch() {
        try {
            String tpsPath = Paths.get(EnvUtil.getNacosHome(), "data" + File.separator + "tps" + File.separator).toString();
            this.checkBaseDir();
            WatchFileCenter.registerWatcher((String)tpsPath, (FileWatcher)new FileWatcher(){

                public void onChange(FileChangeEvent event) {
                    String fileName = event.getContext().toString();
                    try {
                        if (TpsMonitorManager.this.points.get(fileName) != null) {
                            TpsMonitorManager.this.loadRuleFromLocal(TpsMonitorManager.this.points.get(fileName));
                        }
                    }
                    catch (Throwable throwable) {
                        Loggers.TPS_CONTROL.warn("Fail to load rule from local,pointName={},error={}", (Object)fileName, (Object)throwable);
                    }
                }

                public boolean interest(String context) {
                    for (String pointName : TpsMonitorManager.this.points.keySet()) {
                        if (!context.equals(pointName)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (NacosException e) {
            Loggers.TPS_CONTROL.warn("Register fire watch fail.", (Throwable)e);
        }
    }

    public boolean applyTpsForClientIp(String pointName, String connectionId, String clientIp) {
        if (this.points.containsKey(pointName)) {
            return this.points.get(pointName).applyTps(connectionId, Arrays.asList(new ClientIpMonitorKey(clientIp)));
        }
        return true;
    }

    public boolean applyTps(String pointName, String connectionId, List<MonitorKey> monitorKeyList) {
        if (this.points.containsKey(pointName)) {
            return this.points.get(pointName).applyTps(connectionId, monitorKeyList);
        }
        return true;
    }

    public void onEvent(TpsControlRuleChangeEvent event) {
        Loggers.TPS_CONTROL.info("Tps control rule change event receive,pointName={}, ruleContent={} ", (Object)event.getPointName(), (Object)event.ruleContent);
        if (event == null || event.getPointName() == null) {
            return;
        }
        try {
            TpsControlRule tpsControlRule;
            TpsControlRule tpsControlRule2 = tpsControlRule = StringUtils.isBlank((String)event.ruleContent) ? new TpsControlRule() : (TpsControlRule)JacksonUtils.toObj((String)event.ruleContent, TpsControlRule.class);
            if (!this.points.containsKey(event.getPointName())) {
                Loggers.TPS_CONTROL.info("Tps control rule change event ignore,pointName={} ", (Object)event.getPointName());
                return;
            }
            try {
                this.saveRuleToLocal(event.getPointName(), tpsControlRule);
            }
            catch (Throwable throwable) {
                Loggers.TPS_CONTROL.warn("Tps control rule persist fail,pointName={},error={} ", (Object)event.getPointName(), (Object)throwable);
            }
        }
        catch (Exception e) {
            Loggers.TPS_CONTROL.warn("Tps control rule apply error ,error={} ", (Throwable)e);
        }
    }

    public Class<? extends Event> subscribeType() {
        return TpsControlRuleChangeEvent.class;
    }

    private synchronized void loadRuleFromLocal(TpsMonitorPoint tpsMonitorPoint) throws IOException {
        String ruleContent;
        File pointFile = this.getRuleFile(tpsMonitorPoint.getPointName());
        if (!pointFile.exists()) {
            pointFile.createNewFile();
        }
        TpsControlRule tpsControlRule = StringUtils.isBlank((String)(ruleContent = DiskUtils.readFile((File)pointFile))) ? new TpsControlRule() : (TpsControlRule)JacksonUtils.toObj((String)ruleContent, TpsControlRule.class);
        Loggers.TPS_CONTROL.info("Load rule from local,pointName={}, ruleContent={} ", (Object)tpsMonitorPoint.getPointName(), (Object)ruleContent);
        tpsMonitorPoint.applyRule(tpsControlRule);
    }

    private synchronized void saveRuleToLocal(String pointName, TpsControlRule tpsControlRule) throws IOException {
        File pointFile = this.getRuleFile(pointName);
        if (!pointFile.exists()) {
            pointFile.createNewFile();
        }
        String content = JacksonUtils.toJson((Object)tpsControlRule);
        DiskUtils.writeFile((File)pointFile, (byte[])content.getBytes("UTF-8"), (boolean)false);
        Loggers.TPS_CONTROL.info("Save rule to local,pointName={}, ruleContent ={} ", (Object)pointName, (Object)content);
    }

    private File getRuleFile(String pointName) {
        File baseDir = this.checkBaseDir();
        File pointFile = new File(baseDir, pointName);
        return pointFile;
    }

    private File checkBaseDir() {
        File baseDir = new File(EnvUtil.getNacosHome(), "data" + File.separator + "tps" + File.separator);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        return baseDir;
    }

    class TpsMonitorReporter
    implements Runnable {
        long lastReportSecond = 0L;
        long lastReportMinutes = 0L;

        TpsMonitorReporter() {
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                StringBuilder stringBuilder = new StringBuilder();
                Set<Map.Entry<String, TpsMonitorPoint>> entries = TpsMonitorManager.this.points.entrySet();
                long tempSecond = 0L;
                long tempMinutes = 0L;
                String formatString = TpsMonitorPoint.getTimeFormatOfSecond(now - 1000L);
                for (Map.Entry<String, TpsMonitorPoint> entry : entries) {
                    TpsMonitorPoint value = entry.getValue();
                    TpsRecorder.TpsSlot pointSlot = value.getTpsRecorder().getPoint(now - 1000L);
                    if (pointSlot == null || this.lastReportSecond != 0L && this.lastReportSecond == pointSlot.time) continue;
                    String point = entry.getKey();
                    tempSecond = pointSlot.time;
                    stringBuilder.append(point).append("|").append("point|").append((Object)value.getTpsRecorder().period).append("|").append(formatString).append("|").append(pointSlot.getCountHolder((String)point).count.get()).append("|").append(pointSlot.getCountHolder((String)point).interceptedCount.get()).append("\n");
                    for (Map.Entry<String, TpsRecorder> monitorKeyEntry : value.monitorKeysRecorder.entrySet()) {
                        String monitorPattern = monitorKeyEntry.getKey();
                        TpsRecorder ipRecord = monitorKeyEntry.getValue();
                        TpsRecorder.TpsSlot keySlot = ipRecord.getPoint(now - ipRecord.period.toMillis(1L));
                        if (keySlot == null || ipRecord.period == TimeUnit.SECONDS && this.lastReportSecond != 0L && this.lastReportSecond == keySlot.time || ipRecord.period == TimeUnit.MINUTES && this.lastReportMinutes != 0L && this.lastReportMinutes == keySlot.time) continue;
                        String timeFormatOfSecond = TpsMonitorPoint.getTimeFormatOfSecond(keySlot.time);
                        tempMinutes = keySlot.time;
                        if (ipRecord.isProtoModel()) {
                            Map<String, TpsRecorder.SlotCountHolder> keySlots = ((TpsRecorder.MultiKeyTpsSlot)keySlot).keySlots;
                            for (Map.Entry<String, TpsRecorder.SlotCountHolder> slotCountHolder : keySlots.entrySet()) {
                                stringBuilder.append(point).append("|").append(monitorPattern).append("|").append((Object)ipRecord.period).append("|").append(timeFormatOfSecond).append("|").append(slotCountHolder.getKey()).append("|").append(slotCountHolder.getValue().count).append("|").append(slotCountHolder.getValue().interceptedCount).append("\n");
                            }
                            continue;
                        }
                        stringBuilder.append(point).append("|").append(monitorPattern).append("|").append((Object)ipRecord.period).append("|").append(timeFormatOfSecond).append("|").append(keySlot.getCountHolder((String)point).count.get()).append("|").append(keySlot.getCountHolder((String)point).interceptedCount.get()).append("\n");
                    }
                }
                if (tempSecond > 0L) {
                    this.lastReportSecond = tempSecond;
                }
                if (tempMinutes > 0L) {
                    this.lastReportMinutes = tempMinutes;
                }
                if (stringBuilder.length() > 0) {
                    Loggers.TPS_CONTROL_DIGEST.info("Tps reporting...\n" + stringBuilder.toString());
                }
            }
            catch (Throwable throwable) {
                Loggers.TPS_CONTROL_DIGEST.error("Tps reporting error", throwable);
            }
        }
    }
}

