/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ConnectionMeta {
    String connectType;
    String clientIp;
    String remoteIp;
    int remotePort;
    int localPort;
    String version;
    String connectionId;
    Date createTime;
    long lastActiveTime;
    String appName;
    String tenant;
    protected Map<String, String> labels = new HashMap<String, String>();

    public String getLabel(String labelKey) {
        return this.labels.get(labelKey);
    }

    public String getTag() {
        return this.labels.get("Vipserver-Tag");
    }

    public ConnectionMeta(String connectionId, String clientIp, String remoteIp, int remotePort, int localPort, String connectType, String version, String appName, Map<String, String> labels) {
        this.connectionId = connectionId;
        this.clientIp = clientIp;
        this.connectType = connectType;
        this.version = version;
        this.appName = appName;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.localPort = localPort;
        this.createTime = new Date();
        this.lastActiveTime = System.currentTimeMillis();
        this.labels.putAll(labels);
    }

    public boolean isSdkSource() {
        String source = this.labels.get("source");
        return "sdk".equalsIgnoreCase(source);
    }

    public boolean isClusterSource() {
        String source = this.labels.get("source");
        return "cluster".equalsIgnoreCase(source);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public String getConnectType() {
        return this.connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

