/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.remote.PayloadRegistry;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import javax.annotation.PostConstruct;

public abstract class BaseRpcServer {
    @PostConstruct
    public void start() throws Exception {
        final String serverName = this.getClass().getSimpleName();
        Loggers.REMOTE.info("Nacos {} Rpc server starting at port {}", (Object)serverName, (Object)this.getServicePort());
        this.startServer();
        Loggers.REMOTE.info("Nacos {} Rpc server started at port {}", (Object)serverName, (Object)this.getServicePort());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Loggers.REMOTE.info("Nacos {} Rpc server stopping", (Object)serverName);
                try {
                    BaseRpcServer.this.stopServer();
                    Loggers.REMOTE.info("Nacos {} Rpc server stopped successfully...", (Object)serverName);
                }
                catch (Exception e) {
                    Loggers.REMOTE.error("Nacos {} Rpc server stopped fail...", (Object)serverName, (Object)e);
                }
            }
        });
    }

    public abstract ConnectionType getConnectionType();

    public abstract void startServer() throws Exception;

    public abstract int rpcPortOffset();

    public int getServicePort() {
        return EnvUtil.getPort() + this.rpcPortOffset();
    }

    public final void stopServer() throws Exception {
        this.shutdownServer();
    }

    public abstract void shutdownServer();

    static {
        PayloadRegistry.init();
    }
}

