/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.utils;

import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.core.distributed.raft.RaftConfig;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.option.ReadOnlyOption;
import org.apache.commons.lang3.StringUtils;

public class RaftOptionsBuilder {
    public static RaftOptions initRaftOptions(RaftConfig config) {
        RaftOptions raftOptions = new RaftOptions();
        raftOptions.setReadOnlyOptions(RaftOptionsBuilder.raftReadIndexType(config));
        raftOptions.setMaxByteCountPerRpc(ConvertUtils.toInt((String)config.getVal("max_byte_count_per_rpc"), (int)131072));
        raftOptions.setMaxEntriesSize(ConvertUtils.toInt((String)config.getVal("max_entries_size"), (int)1024));
        raftOptions.setMaxBodySize(ConvertUtils.toInt((String)config.getVal("max_body_size"), (int)524288));
        raftOptions.setMaxAppendBufferSize(ConvertUtils.toInt((String)config.getVal("max_append_buffer_size"), (int)262144));
        raftOptions.setMaxElectionDelayMs(ConvertUtils.toInt((String)config.getVal("max_election_delay_ms"), (int)1000));
        raftOptions.setElectionHeartbeatFactor(ConvertUtils.toInt((String)config.getVal("election_heartbeat_factor"), (int)10));
        raftOptions.setApplyBatch(ConvertUtils.toInt((String)config.getVal("apply_batch"), (int)32));
        raftOptions.setSync(ConvertUtils.toBoolean((String)config.getVal("sync"), (boolean)true));
        raftOptions.setSyncMeta(ConvertUtils.toBoolean((String)config.getVal("sync_meta"), (boolean)false));
        raftOptions.setDisruptorBufferSize(ConvertUtils.toInt((String)config.getVal("disruptor_buffer_size"), (int)16384));
        raftOptions.setReplicatorPipeline(ConvertUtils.toBoolean((String)config.getVal("replicator_pipeline"), (boolean)true));
        raftOptions.setMaxReplicatorInflightMsgs(ConvertUtils.toInt((String)config.getVal("max_replicator_inflight_msgs"), (int)256));
        raftOptions.setEnableLogEntryChecksum(ConvertUtils.toBoolean((String)config.getVal("enable_log_entry_checksum"), (boolean)false));
        return raftOptions;
    }

    private static ReadOnlyOption raftReadIndexType(RaftConfig config) {
        String readOnySafe = "ReadOnlySafe";
        String readOnlyLeaseBased = "ReadOnlyLeaseBased";
        String val = config.getVal("read_index_type");
        if (StringUtils.isBlank((CharSequence)val) || StringUtils.equals((CharSequence)readOnySafe, (CharSequence)val)) {
            return ReadOnlyOption.ReadOnlySafe;
        }
        if (StringUtils.equals((CharSequence)readOnlyLeaseBased, (CharSequence)val)) {
            return ReadOnlyOption.ReadOnlyLeaseBased;
        }
        throw new IllegalArgumentException("Illegal Raft system parameters => ReadOnlyOption : [" + val + "], should be 'ReadOnlySafe' or 'ReadOnlyLeaseBased'");
    }
}

