/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.utils;

import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.entity.GetRequest;
import com.alibaba.nacos.consistency.entity.Log;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.processor.NacosGetRequestProcessor;
import com.alibaba.nacos.core.distributed.raft.processor.NacosLogProcessor;
import com.alibaba.nacos.core.distributed.raft.processor.NacosReadRequestProcessor;
import com.alibaba.nacos.core.distributed.raft.processor.NacosWriteRequestProcessor;
import com.alibaba.nacos.core.distributed.raft.utils.RaftExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.GrpcRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.MarshallerRegistry;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class JRaftUtils {
    public static RpcServer initRpcServer(JRaftServer server, PeerId peerId) {
        GrpcRaftRpcFactory raftRpcFactory = (GrpcRaftRpcFactory)RpcFactoryHelper.rpcFactory();
        raftRpcFactory.registerProtobufSerializer(Log.class.getName(), new Object[]{Log.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(GetRequest.class.getName(), new Object[]{GetRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(WriteRequest.class.getName(), new Object[]{WriteRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(ReadRequest.class.getName(), new Object[]{ReadRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(Response.class.getName(), new Object[]{Response.getDefaultInstance()});
        MarshallerRegistry registry = raftRpcFactory.getMarshallerRegistry();
        registry.registerResponseInstance(Log.class.getName(), (Message)Response.getDefaultInstance());
        registry.registerResponseInstance(GetRequest.class.getName(), (Message)Response.getDefaultInstance());
        registry.registerResponseInstance(WriteRequest.class.getName(), (Message)Response.getDefaultInstance());
        registry.registerResponseInstance(ReadRequest.class.getName(), (Message)Response.getDefaultInstance());
        RpcServer rpcServer = raftRpcFactory.createRpcServer(peerId.getEndpoint());
        RaftRpcServerFactory.addRaftRequestProcessors((RpcServer)rpcServer, (Executor)RaftExecutor.getRaftCoreExecutor(), (Executor)RaftExecutor.getRaftCliServiceExecutor());
        rpcServer.registerProcessor((RpcProcessor)new NacosLogProcessor(server, SerializeFactory.getDefault()));
        rpcServer.registerProcessor((RpcProcessor)new NacosGetRequestProcessor(server, SerializeFactory.getDefault()));
        rpcServer.registerProcessor((RpcProcessor)new NacosWriteRequestProcessor(server, SerializeFactory.getDefault()));
        rpcServer.registerProcessor((RpcProcessor)new NacosReadRequestProcessor(server, SerializeFactory.getDefault()));
        return rpcServer;
    }

    public static final void initDirectory(String parentPath, String groupName, NodeOptions copy) {
        String logUri = Paths.get(parentPath, groupName, "log").toString();
        String snapshotUri = Paths.get(parentPath, groupName, "snapshot").toString();
        String metaDataUri = Paths.get(parentPath, groupName, "meta-data").toString();
        try {
            DiskUtils.forceMkdir((File)new File(logUri));
            DiskUtils.forceMkdir((File)new File(snapshotUri));
            DiskUtils.forceMkdir((File)new File(metaDataUri));
        }
        catch (Exception e) {
            Loggers.RAFT.error("Init Raft-File dir have some error : {}", (Throwable)e);
            throw new RuntimeException(e);
        }
        copy.setLogUri(logUri);
        copy.setRaftMetaUri(metaDataUri);
        copy.setSnapshotUri(snapshotUri);
    }

    public static List<String> toStrings(List<PeerId> peerIds) {
        return peerIds.stream().map(peerId -> peerId.getEndpoint().toString()).collect(Collectors.toList());
    }

    public static void joinCluster(CliService cliService, Collection<String> members, Configuration conf, String group, PeerId self) {
        ServerMemberManager memberManager = (ServerMemberManager)ApplicationUtils.getBean(ServerMemberManager.class);
        if (!memberManager.isFirstIp()) {
            return;
        }
        HashSet<PeerId> peerIds = new HashSet<PeerId>();
        for (String s : members) {
            peerIds.add(PeerId.parsePeer((String)s));
        }
        peerIds.remove(self);
        while (!peerIds.isEmpty()) {
            conf = RouteTable.getInstance().getConfiguration(group);
            Iterator iterator = peerIds.iterator();
            while (iterator.hasNext()) {
                PeerId peerId = (PeerId)iterator.next();
                if (conf.contains(peerId)) {
                    iterator.remove();
                    continue;
                }
                Status status = cliService.addPeer(group, conf, peerId);
                if (!status.isOk()) continue;
                iterator.remove();
            }
            ThreadUtils.sleep((long)1000L);
        }
        return;
    }
}

