/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.verify;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.List;

public class DistroVerifyExecuteTask
extends AbstractExecuteTask {
    private final DistroTransportAgent transportAgent;
    private final List<DistroData> verifyData;
    private final String targetServer;
    private final String resourceType;

    public DistroVerifyExecuteTask(DistroTransportAgent transportAgent, List<DistroData> verifyData, String targetServer, String resourceType) {
        this.transportAgent = transportAgent;
        this.verifyData = verifyData;
        this.targetServer = targetServer;
        this.resourceType = resourceType;
    }

    public void run() {
        for (DistroData each : this.verifyData) {
            try {
                if (this.transportAgent.supportCallbackTransport()) {
                    this.doSyncVerifyDataWithCallback(each);
                    continue;
                }
                this.doSyncVerifyData(each);
            }
            catch (Exception e) {
                Loggers.DISTRO.error("[DISTRO-FAILED] verify data for type {} to {} failed.", new Object[]{this.resourceType, this.targetServer, e});
            }
        }
    }

    private void doSyncVerifyDataWithCallback(DistroData data) {
        this.transportAgent.syncVerifyData(data, this.targetServer, new DistroVerifyCallback());
    }

    private void doSyncVerifyData(DistroData data) {
        this.transportAgent.syncVerifyData(data, this.targetServer);
    }

    private class DistroVerifyCallback
    implements DistroCallback {
        private DistroVerifyCallback() {
        }

        @Override
        public void onSuccess() {
            if (Loggers.DISTRO.isDebugEnabled()) {
                Loggers.DISTRO.debug("[DISTRO] verify data for type {} to {} success", (Object)DistroVerifyExecuteTask.this.resourceType, (Object)DistroVerifyExecuteTask.this.targetServer);
            }
        }

        @Override
        public void onFailed(Throwable throwable) {
            if (Loggers.DISTRO.isDebugEnabled()) {
                Loggers.DISTRO.debug("[DISTRO-FAILED] verify data for type {} to {} failed.", new Object[]{DistroVerifyExecuteTask.this.resourceType, DistroVerifyExecuteTask.this.targetServer, throwable});
            }
        }
    }
}

