/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.execute;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.component.DistroFailedTaskHandler;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.utils.Loggers;

public abstract class AbstractDistroExecuteTask
extends AbstractExecuteTask {
    private final DistroKey distroKey;
    private final DistroComponentHolder distroComponentHolder;

    protected AbstractDistroExecuteTask(DistroKey distroKey, DistroComponentHolder distroComponentHolder) {
        this.distroKey = distroKey;
        this.distroComponentHolder = distroComponentHolder;
    }

    protected DistroKey getDistroKey() {
        return this.distroKey;
    }

    protected DistroComponentHolder getDistroComponentHolder() {
        return this.distroComponentHolder;
    }

    public void run() {
        String type = this.getDistroKey().getResourceType();
        DistroTransportAgent transportAgent = this.distroComponentHolder.findTransportAgent(type);
        if (null == transportAgent) {
            Loggers.DISTRO.warn("No found transport agent for type [{}]", (Object)type);
            return;
        }
        Loggers.DISTRO.info("[DISTRO-START] {}", (Object)((Object)((Object)this)).toString());
        if (transportAgent.supportCallbackTransport()) {
            this.doExecuteWithCallback(new DistroExecuteCallback());
        } else {
            this.executeDistroTask();
        }
    }

    private void executeDistroTask() {
        try {
            boolean result = this.doExecute();
            if (!result) {
                this.handleFailedTask();
            }
            Loggers.DISTRO.info("[DISTRO-END] {} result: {}", (Object)((Object)((Object)this)).toString(), (Object)result);
        }
        catch (Exception e) {
            Loggers.DISTRO.warn("[DISTRO] Sync data change failed.", (Throwable)e);
            this.handleFailedTask();
        }
    }

    protected abstract DataOperation getDataOperation();

    protected abstract boolean doExecute();

    protected abstract void doExecuteWithCallback(DistroCallback var1);

    protected void handleFailedTask() {
        String type = this.getDistroKey().getResourceType();
        DistroFailedTaskHandler failedTaskHandler = this.distroComponentHolder.findFailedTaskHandler(type);
        if (null == failedTaskHandler) {
            Loggers.DISTRO.warn("[DISTRO] Can't find failed task for type {}, so discarded", (Object)type);
            return;
        }
        failedTaskHandler.retry(this.getDistroKey(), this.getDataOperation());
    }

    private class DistroExecuteCallback
    implements DistroCallback {
        private DistroExecuteCallback() {
        }

        @Override
        public void onSuccess() {
            Loggers.DISTRO.info("[DISTRO-END] {} result: true", (Object)AbstractDistroExecuteTask.this.getDistroKey().toString());
        }

        @Override
        public void onFailed(Throwable throwable) {
            if (null == throwable) {
                Loggers.DISTRO.info("[DISTRO-END] {} result: false", (Object)AbstractDistroExecuteTask.this.getDistroKey().toString());
            } else {
                Loggers.DISTRO.warn("[DISTRO] Sync data change failed.", throwable);
            }
            AbstractDistroExecuteTask.this.handleFailedTask();
        }
    }
}

