/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro;

import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.distro.DistroConfig;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataProcessor;
import com.alibaba.nacos.core.distributed.distro.component.DistroDataStorage;
import com.alibaba.nacos.core.distributed.distro.component.DistroTransportAgent;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.task.DistroTaskEngineHolder;
import com.alibaba.nacos.core.distributed.distro.task.delay.DistroDelayTask;
import com.alibaba.nacos.core.distributed.distro.task.load.DistroLoadDataTask;
import com.alibaba.nacos.core.distributed.distro.task.verify.DistroVerifyTimedTask;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.stereotype.Component;

@Component
public class DistroProtocol {
    private final ServerMemberManager memberManager;
    private final DistroComponentHolder distroComponentHolder;
    private final DistroTaskEngineHolder distroTaskEngineHolder;
    private final DistroConfig distroConfig;
    private volatile boolean isInitialized = false;

    public DistroProtocol(ServerMemberManager memberManager, DistroComponentHolder distroComponentHolder, DistroTaskEngineHolder distroTaskEngineHolder, DistroConfig distroConfig) {
        this.memberManager = memberManager;
        this.distroComponentHolder = distroComponentHolder;
        this.distroTaskEngineHolder = distroTaskEngineHolder;
        this.distroConfig = distroConfig;
        this.startDistroTask();
    }

    private void startDistroTask() {
        if (EnvUtil.getStandaloneMode()) {
            this.isInitialized = true;
            return;
        }
        this.startVerifyTask();
        this.startLoadTask();
    }

    private void startLoadTask() {
        DistroCallback loadCallback = new DistroCallback(){

            @Override
            public void onSuccess() {
                DistroProtocol.this.isInitialized = true;
            }

            @Override
            public void onFailed(Throwable throwable) {
                DistroProtocol.this.isInitialized = false;
            }
        };
        GlobalExecutor.submitLoadDataTask(new DistroLoadDataTask(this.memberManager, this.distroComponentHolder, this.distroConfig, loadCallback));
    }

    private void startVerifyTask() {
        GlobalExecutor.schedulePartitionDataTimedSync(new DistroVerifyTimedTask(this.memberManager, this.distroComponentHolder, this.distroTaskEngineHolder.getExecuteWorkersManager()), this.distroConfig.getVerifyIntervalMillis());
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void sync(DistroKey distroKey, DataOperation action) {
        this.sync(distroKey, action, this.distroConfig.getSyncDelayMillis());
    }

    public void sync(DistroKey distroKey, DataOperation action, long delay) {
        for (Member each : this.memberManager.allMembersWithoutSelf()) {
            this.syncToTarget(distroKey, action, each.getAddress(), delay);
        }
    }

    public void syncToTarget(DistroKey distroKey, DataOperation action, String targetServer, long delay) {
        DistroKey distroKeyWithTarget = new DistroKey(distroKey.getResourceKey(), distroKey.getResourceType(), targetServer);
        DistroDelayTask distroDelayTask = new DistroDelayTask(distroKeyWithTarget, action, delay);
        this.distroTaskEngineHolder.getDelayTaskExecuteEngine().addTask(distroKeyWithTarget, distroDelayTask);
        if (Loggers.DISTRO.isDebugEnabled()) {
            Loggers.DISTRO.debug("[DISTRO-SCHEDULE] {} to {}", (Object)distroKey, (Object)targetServer);
        }
    }

    public DistroData queryFromRemote(DistroKey distroKey) {
        if (null == distroKey.getTargetServer()) {
            Loggers.DISTRO.warn("[DISTRO] Can't query data from empty server");
            return null;
        }
        String resourceType = distroKey.getResourceType();
        DistroTransportAgent transportAgent = this.distroComponentHolder.findTransportAgent(resourceType);
        if (null == transportAgent) {
            Loggers.DISTRO.warn("[DISTRO] Can't find transport agent for key {}", (Object)resourceType);
            return null;
        }
        return transportAgent.getData(distroKey, distroKey.getTargetServer());
    }

    public boolean onReceive(DistroData distroData) {
        Loggers.DISTRO.info("[DISTRO] Receive distro data type: {}, key: {}", (Object)distroData.getType(), (Object)distroData.getDistroKey());
        String resourceType = distroData.getDistroKey().getResourceType();
        DistroDataProcessor dataProcessor = this.distroComponentHolder.findDataProcessor(resourceType);
        if (null == dataProcessor) {
            Loggers.DISTRO.warn("[DISTRO] Can't find data process for received data {}", (Object)resourceType);
            return false;
        }
        return dataProcessor.processData(distroData);
    }

    public boolean onVerify(DistroData distroData, String sourceAddress) {
        String resourceType;
        DistroDataProcessor dataProcessor;
        if (Loggers.DISTRO.isDebugEnabled()) {
            Loggers.DISTRO.debug("[DISTRO] Receive verify data type: {}, key: {}", (Object)distroData.getType(), (Object)distroData.getDistroKey());
        }
        if (null == (dataProcessor = this.distroComponentHolder.findDataProcessor(resourceType = distroData.getDistroKey().getResourceType()))) {
            Loggers.DISTRO.warn("[DISTRO] Can't find verify data process for received data {}", (Object)resourceType);
            return false;
        }
        return dataProcessor.processVerifyData(distroData, sourceAddress);
    }

    public DistroData onQuery(DistroKey distroKey) {
        String resourceType = distroKey.getResourceType();
        DistroDataStorage distroDataStorage = this.distroComponentHolder.findDataStorage(resourceType);
        if (null == distroDataStorage) {
            Loggers.DISTRO.warn("[DISTRO] Can't find data storage for received key {}", (Object)resourceType);
            return new DistroData(distroKey, new byte[0]);
        }
        return distroDataStorage.getDistroData(distroKey);
    }

    public DistroData onSnapshot(String type) {
        DistroDataStorage distroDataStorage = this.distroComponentHolder.findDataStorage(type);
        if (null == distroDataStorage) {
            Loggers.DISTRO.warn("[DISTRO] Can't find data storage for received key {}", (Object)type);
            return new DistroData(new DistroKey("snapshot", type), new byte[0]);
        }
        return distroDataStorage.getDatumSnapshot();
    }
}

