/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.auth.AuthManager;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.AuthConfigs;
import com.alibaba.nacos.auth.exception.AccessException;
import com.alibaba.nacos.auth.model.Permission;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.core.utils.Loggers;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteRequestAuthFilter
extends AbstractRequestFilter {
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private AuthManager authManager;

    @Override
    public Response filter(Request request, RequestMeta meta, Class handlerClazz) throws NacosException {
        try {
            Method method = this.getHandleMethod(handlerClazz);
            if (method.isAnnotationPresent(Secured.class) && this.authConfigs.isAuthEnabled()) {
                if (Loggers.AUTH.isDebugEnabled()) {
                    Loggers.AUTH.debug("auth start, request: {}", (Object)request.getClass().getSimpleName());
                }
                Secured secured = method.getAnnotation(Secured.class);
                String action = secured.action().toString();
                String resource = secured.resource();
                if (StringUtils.isBlank((CharSequence)resource)) {
                    ResourceParser parser = (ResourceParser)secured.parser().newInstance();
                    resource = parser.parseName((Object)request);
                }
                if (StringUtils.isBlank((CharSequence)resource)) {
                    throw new AccessException("resource name invalid!");
                }
                this.authManager.auth(new Permission(resource, action), this.authManager.loginRemote((Object)request));
            }
        }
        catch (AccessException e) {
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("access denied, request: {}, reason: {}", (Object)request.getClass().getSimpleName(), (Object)e.getErrMsg());
            }
            Response defaultResponseInstance = this.getDefaultResponseInstance(handlerClazz);
            defaultResponseInstance.setErrorInfo(403, e.getMessage());
            return defaultResponseInstance;
        }
        catch (Exception e) {
            Response defaultResponseInstance = this.getDefaultResponseInstance(handlerClazz);
            defaultResponseInstance.setErrorInfo(500, ExceptionUtil.getAllExceptionMsg((Throwable)e));
            return defaultResponseInstance;
        }
        return null;
    }
}

