/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.execute;

import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.component.DistroFailedTaskHandler;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.task.execute.AbstractDistroExecuteTask;
import com.alibaba.nacos.core.utils.Loggers;

public class DistroSyncChangeTask
extends AbstractDistroExecuteTask {
    private final DistroComponentHolder distroComponentHolder;

    public DistroSyncChangeTask(DistroKey distroKey, DistroComponentHolder distroComponentHolder) {
        super(distroKey);
        this.distroComponentHolder = distroComponentHolder;
    }

    public void run() {
        Loggers.DISTRO.info("[DISTRO-START] {}", (Object)this.toString());
        try {
            String type = this.getDistroKey().getResourceType();
            DistroData distroData = this.distroComponentHolder.findDataStorage(type).getDistroData(this.getDistroKey());
            distroData.setType(DataOperation.CHANGE);
            boolean result = this.distroComponentHolder.findTransportAgent(type).syncData(distroData, this.getDistroKey().getTargetServer());
            if (!result) {
                this.handleFailedTask();
            }
            Loggers.DISTRO.info("[DISTRO-END] {} result: {}", (Object)this.toString(), (Object)result);
        }
        catch (Exception e) {
            Loggers.DISTRO.warn("[DISTRO] Sync data change failed.", (Throwable)e);
            this.handleFailedTask();
        }
    }

    private void handleFailedTask() {
        String type = this.getDistroKey().getResourceType();
        DistroFailedTaskHandler failedTaskHandler = this.distroComponentHolder.findFailedTaskHandler(type);
        if (null == failedTaskHandler) {
            Loggers.DISTRO.warn("[DISTRO] Can't find failed task for type {}, so discarded", (Object)type);
            return;
        }
        failedTaskHandler.retry(this.getDistroKey(), DataOperation.CHANGE);
    }

    public String toString() {
        return "DistroSyncChangeTask for " + this.getDistroKey().toString();
    }
}

