/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed;

import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.raft.JRaftProtocol;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConsistencyConfiguration {
    @Bean(value={"strongAgreementProtocol"})
    public CPProtocol strongAgreementProtocol(ServerMemberManager memberManager) throws Exception {
        CPProtocol protocol = this.getProtocol(CPProtocol.class, () -> new JRaftProtocol(memberManager));
        return protocol;
    }

    private <T> T getProtocol(Class<T> cls, Callable<T> builder) throws Exception {
        ServiceLoader<T> protocols = ServiceLoader.load(cls);
        Iterator<T> iterator = protocols.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return builder.call();
    }
}

