/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.core.utils.StringPool;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class MD5Util {
    static final char WORD_SEPARATOR_CHAR = '\u0002';
    static final char LINE_SEPARATOR_CHAR = '\u0001';

    public static List<String> compareMd5(HttpServletRequest request, HttpServletResponse response, Map<String, String> clientMd5Map) {
        ArrayList<String> changedGroupKeys = new ArrayList<String>();
        String tag = request.getHeader("Vipserver-Tag");
        for (Map.Entry<String, String> entry : clientMd5Map.entrySet()) {
            String ip;
            String clientMd5;
            String groupKey = entry.getKey();
            boolean isUptodate = ConfigCacheService.isUptodate(groupKey, clientMd5 = entry.getValue(), ip = RequestUtil.getRemoteIp(request), tag);
            if (isUptodate) continue;
            changedGroupKeys.add(groupKey);
        }
        return changedGroupKeys;
    }

    public static String compareMd5OldResult(List<String> changedGroupKeys) {
        StringBuilder sb = new StringBuilder();
        for (String groupKey : changedGroupKeys) {
            String[] dataIdGroupId = GroupKey2.parseKey(groupKey);
            sb.append(dataIdGroupId[0]);
            sb.append(":");
            sb.append(dataIdGroupId[1]);
            sb.append(";");
        }
        return sb.toString();
    }

    public static String compareMd5ResultString(List<String> changedGroupKeys) throws IOException {
        if (null == changedGroupKeys) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String groupKey : changedGroupKeys) {
            String[] dataIdGroupId = GroupKey2.parseKey(groupKey);
            sb.append(dataIdGroupId[0]);
            sb.append(Constants.WORD_SEPARATOR);
            sb.append(dataIdGroupId[1]);
            if (dataIdGroupId.length == 3 && StringUtils.isNotBlank((CharSequence)dataIdGroupId[2])) {
                sb.append(Constants.WORD_SEPARATOR);
                sb.append(dataIdGroupId[2]);
            }
            sb.append(Constants.LINE_SEPARATOR);
        }
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }

    public static Map<String, String> getClientMd5Map(String configKeysString) {
        HashMap<String, String> md5Map = new HashMap<String, String>(5);
        if (null == configKeysString || "".equals(configKeysString)) {
            return md5Map;
        }
        int start = 0;
        ArrayList<String> tmpList = new ArrayList<String>(3);
        for (int i = start; i < configKeysString.length(); ++i) {
            String groupKey;
            char c = configKeysString.charAt(i);
            if (c == '\u0002') {
                tmpList.add(configKeysString.substring(start, i));
                start = i + 1;
                if (tmpList.size() <= 3) continue;
                throw new IllegalArgumentException("invalid protocol,too much key");
            }
            if (c != '\u0001') continue;
            String endValue = "";
            if (start + 1 <= i) {
                endValue = configKeysString.substring(start, i);
            }
            start = i + 1;
            if (tmpList.size() == 2) {
                groupKey = GroupKey2.getKey((String)tmpList.get(0), (String)tmpList.get(1));
                groupKey = StringPool.get((String)groupKey);
                md5Map.put(groupKey, endValue);
            } else {
                groupKey = GroupKey2.getKey((String)tmpList.get(0), (String)tmpList.get(1), endValue);
                groupKey = StringPool.get((String)groupKey);
                md5Map.put(groupKey, (String)tmpList.get(2));
            }
            tmpList.clear();
            if (md5Map.size() <= 10000) continue;
            throw new IllegalArgumentException("invalid protocol, too much listener");
        }
        return md5Map;
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? MD5Util.toString(new InputStreamReader(input, "UTF-8")) : MD5Util.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        MD5Util.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[1024];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

