/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.SubInfo;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedStoragePersistServiceImpl
implements PersistService {
    private static final String RESOURCE_CONFIG_INFO_ID = "config-info-id";
    private static final String RESOURCE_CONFIG_HISTORY_ID = "config-history-id";
    private static final String RESOURCE_CONFIG_TAG_RELATION_ID = "config-tag-relation-id";
    private static final String RESOURCE_APP_CONFIGDATA_RELATION_SUBS = "app-configdata-relation-subs";
    private static final String RESOURCE_CONFIG_BETA_ID = "config-beta-id";
    private static final String RESOURCE_NAMESPACE_ID = "namespace-id";
    private static final String RESOURCE_USER_ID = "user-id";
    private static final String RESOURCE_ROLE_ID = "role-id";
    private static final String RESOURCE_PERMISSIONS_ID = "permissions_id";
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private final IdGeneratorManager idGeneratorManager;

    public EmbeddedStoragePersistServiceImpl(DatabaseOperate databaseOperate, IdGeneratorManager idGeneratorManager) {
        this.databaseOperate = databaseOperate;
        this.idGeneratorManager = idGeneratorManager;
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        this.idGeneratorManager.register(new String[]{RESOURCE_CONFIG_INFO_ID, RESOURCE_CONFIG_HISTORY_ID, RESOURCE_CONFIG_TAG_RELATION_ID, RESOURCE_APP_CONFIGDATA_RELATION_SUBS, RESOURCE_CONFIG_BETA_ID, RESOURCE_NAMESPACE_ID, RESOURCE_USER_ID, RESOURCE_ROLE_ID, RESOURCE_PERMISSIONS_ID});
    }

    public boolean checkMasterWritable() {
        return this.dataSourceService.checkMasterWritable();
    }

    public void setBasicDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public synchronized void reload() throws IOException {
        this.dataSourceService.reload();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.dataSourceService.getJdbcTemplate();
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.dataSourceService.getTransactionTemplate();
    }

    public String getCurrentDBUrl() {
        return this.dataSourceService.getCurrentDbUrl();
    }

    public DatabaseOperate getDatabaseOperate() {
        return this.databaseOperate;
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify, BiConsumer<Boolean, Throwable> consumer) {
        try {
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            configInfo.setTenant(tenantTmp);
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_INFO_ID);
            long hisId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_ID);
            this.addConfigInfoAtomic(configId, srcIp, srcUser, configInfo, time, configAdvanceInfo);
            String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            this.insertConfigHistoryAtomic(hisId, configInfo, srcIp, srcUser, time, "I");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            this.databaseOperate.blockUpdate(consumer);
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "INSERT INTO config_info_beta(data_id,group_id,tenant_id,app_name,content,md5,beta_ips,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
            Object[] args = new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_info_beta(data_id,group_id,tenant_id,app_name,content,md5,beta_ips,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "INSERT INTO config_info_tag(data_id,group_id,tenant_id,tag_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
            Object[] args = new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time};
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_info_tag(data_id,group_id,tenant_id,tag_id,app_name,content,md5,src_ip,src_user,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?,?,?,?,?)", args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, time, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            this.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, time, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            this.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            boolean bl = this.databaseOperate.blockUpdate();
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "UPDATE config_info_beta SET content=?,md5=?,src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=?";
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info_beta SET content=?,md5=?,src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=?", args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "UPDATE config_info_beta SET content=?,md5=?,src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? or md5 is null or md5='')";
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info_beta SET content=?,md5=?,src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? or md5 is null or md5='')", args);
            boolean bl = this.databaseOperate.blockUpdate();
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?";
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp};
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", args);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigInfo4TagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            String sql = "UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=? AND (md5=? or md5 is null or md5='')";
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, configInfo.getMd5()};
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info_tag SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=? WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=? AND (md5=? or md5 is null or md5='')", args);
            boolean bl = this.databaseOperate.blockUpdate();
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Beta(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        } else {
            this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Beta(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            this.addConfigInfo4Beta(configInfo, betaIps, srcIp, null, time, notify);
            return true;
        }
        return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, null, time, notify);
    }

    @Override
    public void insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Tag(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        } else {
            this.updateConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
        }
    }

    @Override
    public boolean insertOrUpdateTagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser, Timestamp time, boolean notify) {
        if (this.findConfigInfo4Tag(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            this.addConfigInfo4Tag(configInfo, tag, srcIp, null, time, notify);
            return true;
        }
        return this.updateConfigInfo4TagCas(configInfo, tag, srcIp, null, time, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMd5(String dataId, String group, String tenant, String md5, Timestamp lastTime) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            String sql = "UPDATE config_info SET md5 = ? WHERE data_id=? AND group_id=? AND tenant_id=? AND gmt_modified=?";
            Object[] args = new Object[]{md5, dataId, group, tenantTmp, lastTime};
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info SET md5 = ? WHERE data_id=? AND group_id=? AND tenant_id=? AND gmt_modified=?", args);
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Failed to config the MD5 modification");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        this.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        if (Objects.isNull(this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
        } else {
            this.updateConfigInfo(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        return this.insertOrUpdateCas(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        if (Objects.isNull(this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
            return true;
        }
        return this.updateConfigInfoCas(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
    }

    @Override
    public void insertOrUpdateSub(SubInfo subInfo) {
        if (this.isAlreadyExist(subInfo)) {
            this.updateConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        } else {
            this.addConfigSubAtomic(subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName(), subInfo.getDate());
        }
    }

    private boolean isAlreadyExist(SubInfo subInfo) {
        String sql = "SELECT * from app_configdata_relation_subs WHERE dara_id=? and group_id=? and app_name=?";
        Map obj = this.databaseOperate.queryOne("SELECT * from app_configdata_relation_subs WHERE dara_id=? and group_id=? and app_name=?", new Object[]{subInfo.getDataId(), subInfo.getGroup(), subInfo.getAppName()}, Map.class);
        return obj != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo(String dataId, String group, String tenant, String srcIp, String srcUser) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        ConfigInfoWrapper configInfo = this.findConfigInfo(dataId, group, tenant);
        if (Objects.nonNull(configInfo)) {
            try {
                String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                this.removeConfigInfoAtomic(dataId, group, tenantTmp, srcIp, srcUser);
                this.removeTagByIdAtomic(configInfo.getId());
                this.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                EmbeddedStorageContextUtils.onDeleteConfigInfo(tenantTmp, group, dataId, srcIp, time);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("config deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextUtils.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigInfo> removeConfigInfoByIds(List<Long> ids, String srcIp, String srcUser) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            String idsStr = Joiner.on((String)",").join(ids);
            List<ConfigInfo> configInfoList = this.findConfigInfosByIds(idsStr);
            if (CollectionUtils.isNotEmpty(configInfoList)) {
                this.removeConfigInfoByIdsAtomic(idsStr);
                for (ConfigInfo configInfo : configInfoList) {
                    this.removeTagByIdAtomic(configInfo.getId());
                    this.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                }
            }
            EmbeddedStorageContextUtils.onBatchDeleteConfigInfo(configInfoList);
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Failed to config batch deletion");
            }
            List<ConfigInfo> list = configInfoList;
            return list;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoBetaWrapper configInfo = this.findConfigInfo4Beta(dataId, group, tenant);
        if (configInfo != null) {
            try {
                String sql = "DELETE FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?";
                Object[] args = new Object[]{dataId, group, tenantTmp};
                EmbeddedStorageContextUtils.onDeleteConfigBetaInfo(tenantTmp, group, dataId, System.currentTimeMillis());
                EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", args);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("[Tag] Configuration deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextUtils.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        Object[] args;
        String appNameTmp = StringUtils.isBlank((CharSequence)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String contentTmp = StringUtils.isBlank((CharSequence)content) ? "" : content;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String select = "SELECT content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?";
        String insert = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
        String update = "UPDATE config_info_aggr SET content = ? , gmt_modified = ? WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?";
        String dbContent = this.databaseOperate.queryOne("SELECT content FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?", new Object[]{dataId, group, tenantTmp, datumId}, String.class);
        if (Objects.isNull(dbContent)) {
            args = new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, contentTmp, now};
            EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ", args);
        } else if (!dbContent.equals(content)) {
            args = new Object[]{contentTmp, now, dataId, group, tenantTmp, datumId};
            EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info_aggr SET content = ? , gmt_modified = ? WHERE data_id = ? AND group_id = ? AND tenant_id = ? AND datum_id = ?", args);
        }
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[Merge] Configuration release failed");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSingleAggrConfigInfo(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        Object[] args = new Object[]{dataId, group, tenantTmp, datumId};
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?", args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation with single] Configuration deletion failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAggrConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=?";
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=?", args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation with all] Configuration deletion failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchRemoveAggr(String dataId, String group, String tenant, List<String> datumList) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append("'").append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        String sql = "delete from config_info_aggr where data_id=? and group_id=? and tenant_id=? and datum_id in (" + datumString.toString() + ")";
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[aggregation] Failed to configure batch deletion");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        String sql = "delete from his_config_info where gmt_modified < ? limit ?";
        PaginationHelper helper = this.createPaginationHelper();
        helper.updateLimit(sql, new Object[]{startTime, limitSize});
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        String sql = "SELECT COUNT(*) FROM his_config_info WHERE gmt_modified < ?";
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{startTime}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public long findConfigMaxId() {
        String sql = "SELECT max(id) FROM config_info";
        return Optional.ofNullable(this.databaseOperate.queryOne(sql, Long.class)).orElse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchPublishAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        try {
            Boolean isPublishOk = false;
            for (Map.Entry<String, String> entry : datumMap.entrySet()) {
                this.addAggrConfigInfo(dataId, group, tenant, entry.getKey(), appName, entry.getValue());
            }
            isPublishOk = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (isPublishOk == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isPublishOk;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        Boolean isReplaceOk = false;
        String appNameTmp = appName == null ? "" : appName;
        this.removeAggrConfigInfo(dataId, group, tenant);
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ";
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            Object[] args = new Object[]{dataId, group, tenantTmp, datumEntry.getKey(), appNameTmp, datumEntry.getValue(), new Timestamp(System.currentTimeMillis())};
            EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_info_aggr(data_id, group_id, tenant_id, datum_id, app_name, content, gmt_modified) VALUES(?,?,?,?,?,?,?) ", args);
        }
        try {
            isReplaceOk = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (isReplaceOk == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isReplaceOk;
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<ConfigInfo> findAllDataIdAndGroup() {
        String sql = "SELECT DISTINCT data_id, group_id FROM config_info";
        return this.databaseOperate.queryMany(sql, EMPTY_ARRAY, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content,beta_ips FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content,beta_ips FROM config_info_beta WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }

    @Override
    public ConfigInfoTagWrapper findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        String sql = "SELECT ID,data_id,group_id,tenant_id,tag_id,app_name,content FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,tag_id,app_name,content FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", new Object[]{dataId, group, tenantTmp, tagTmp}, RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
    }

    @Override
    public ConfigInfo findConfigInfoApp(String dataId, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=? AND app_name=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=? AND app_name=?", new Object[]{dataId, group, tenantTmp, appName}, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfo findConfigInfoAdvanceInfo(String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(group);
        paramList.add(tenantTmp);
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and group_id=? and tenant_id=? ");
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.group_id=? and a.tenant_id=? ");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sql.append(") ");
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appName)) {
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        return this.databaseOperate.queryOne(sql.toString(), paramList.toArray(), RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoBase findConfigInfoBase(String dataId, String group) {
        String sql = "SELECT ID,data_id,group_id,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,content FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, ""}, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ID=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ID=?", new Object[]{id}, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content,md5,type FROM config_info  WHERE data_id=? AND group_id=? AND tenant_id=?";
        Object[] args = new Object[]{dataId, group, tenantTmp};
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5,type FROM config_info  WHERE data_id=? AND group_id=? AND tenant_id=?", args, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataId(int pageNo, int pageSize, String dataId, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where data_id=? and tenant_id=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=?", new Object[]{dataId, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataIdAndApp(int pageNo, int pageSize, String dataId, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where data_id=? and tenant_id=? and app_name=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=? and app_name=?", new Object[]{dataId, tenantTmp, appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByDataIdAndAdvance(int pageNo, int pageSize, String dataId, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where data_id=? and tenant_id=? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where data_id=? and tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(dataId);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.data_id=? and a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sqlCount = "select count(*) from config_info";
        String sql = "select ID,data_id,group_id,tenant_id,app_name,content,type from config_info";
        StringBuilder where = new StringBuilder(" where ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sqlCount = "select count(*) from config_info  a left join config_tags_relation b on a.id=b.id";
            sql = "select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id";
            where.append(" a.tenant_id=? ");
            if (StringUtils.isNotBlank((CharSequence)dataId)) {
                where.append(" and a.data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((CharSequence)group)) {
                where.append(" and a.group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                where.append(" and a.app_name=? ");
                paramList.add(appName);
            }
            where.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append("?");
                paramList.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id=? ");
            if (StringUtils.isNotBlank((CharSequence)dataId)) {
                where.append(" and data_id=? ");
                paramList.add(dataId);
            }
            if (StringUtils.isNotBlank((CharSequence)group)) {
                where.append(" and group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                where.append(" and app_name=? ");
                paramList.add(appName);
            }
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCount + where.toString(), sql + where.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByDataId(int pageNo, int pageSize, String dataId) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where data_id=? and tenant_id=?", "select ID,data_id,group_id,content from config_info where data_id=? and tenant_id=?", new Object[]{dataId, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroup(int pageNo, int pageSize, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where group_id=? and tenant_id=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=?", new Object[]{group, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroupAndApp(int pageNo, int pageSize, String group, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where group_id=? and tenant_id=? and app_name =?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=? and app_name =?", new Object[]{group, tenantTmp, appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByGroupAndAdvance(int pageNo, int pageSize, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where group_id=? and tenant_id=? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where group_id=? and tenant_id=? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(group);
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info  a left join config_tags_relation b on a.id=b.id where a.group_id=?  and a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.group_id=? and a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByApp(int pageNo, int pageSize, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where tenant_id like ? and app_name=?", "select ID,data_id,group_id,tenant_id,app_name,content from config_info where tenant_id like ? and app_name=?", new Object[]{this.generateLikeArgument(tenantTmp), appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByAdvance(int pageNo, int pageSize, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        StringBuilder sqlCount = new StringBuilder("select count(*) from config_info where tenant_id like ? ");
        StringBuilder sql = new StringBuilder("select ID,data_id,group_id,tenant_id,app_name,content from config_info where tenant_id like ? ");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sqlCount = new StringBuilder("select count(*) from config_info a left join config_tags_relation b on a.id=b.id where a.tenant_id=? ");
            sql = new StringBuilder("select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id where a.tenant_id=? ");
            sqlCount.append(" and b.tag_name in (");
            sql.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    sqlCount.append(", ");
                    sql.append(", ");
                }
                sqlCount.append("?");
                sql.append("?");
                paramList.add(tagArr[i]);
            }
            sqlCount.append(") ");
            sql.append(") ");
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                sqlCount.append(" and a.app_name=? ");
                sql.append(" and a.app_name=? ");
                paramList.add(appName);
            }
        } else if (StringUtils.isNotBlank((CharSequence)appName)) {
            sqlCount.append(" and app_name=? ");
            sql.append(" and app_name=? ");
            paramList.add(appName);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCount.toString(), sql.toString(), paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByGroup(int pageNo, int pageSize, String group) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where group_id=? and tenant_id=?", "select ID,data_id,group_id,content from config_info where group_id=? and tenant_id=?", new Object[]{group, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public int configInfoCount() {
        String sql = " SELECT COUNT(ID) FROM config_info ";
        Integer result = this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        String sql = " SELECT COUNT(ID) FROM config_info where tenant_id like ?";
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{tenant}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoBetaCount() {
        String sql = " SELECT COUNT(ID) FROM config_info_beta ";
        Integer result = this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public int configInfoTagCount() {
        String sql = " SELECT COUNT(ID) FROM config_info_tag ";
        Integer result = this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        PaginationHelper<Map<String, Object>> helper = this.createPaginationHelper();
        String sql = "SELECT tenant_id FROM config_info WHERE tenant_id != '' GROUP BY tenant_id LIMIT ?,?";
        int from = (page - 1) * pageSize;
        Page<Map<String, Object>> pageList = helper.fetchPageLimit(sql, new Object[]{from, pageSize}, page, pageSize, RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("TENANT_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        PaginationHelper<Map<String, Object>> helper = this.createPaginationHelper();
        String sql = "SELECT group_id FROM config_info WHERE tenant_id ='' GROUP BY group_id LIMIT ?,?";
        int from = (page - 1) * pageSize;
        Page<Map<String, Object>> pageList = helper.fetchPageLimit(sql, new Object[]{from, pageSize}, page, pageSize, RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("GROUP_ID"))).collect(Collectors.toList());
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String sql = " SELECT COUNT(ID) FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND tenant_id = ?";
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant, List<String> datumIds, boolean isIn) {
        if (datumIds == null || datumIds.isEmpty()) {
            return 0;
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder sql = new StringBuilder(" SELECT COUNT(*) FROM config_info_aggr WHERE data_id = ? and group_id = ? and tenant_id = ? and datum_id");
        if (isIn) {
            sql.append(" in (");
        } else {
            sql.append(" not in (");
        }
        int size = datumIds.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
        }
        sql.append(")");
        ArrayList objectList = Lists.newArrayList((Object[])new Object[]{dataId, group, tenantTmp});
        objectList.addAll(datumIds);
        Integer result = this.databaseOperate.queryOne(sql.toString(), objectList.toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCountIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, true);
    }

    @Override
    public int aggrConfigInfoCountNotIn(String dataId, String group, String tenant, List<String> datumIds) {
        return this.aggrConfigInfoCount(dataId, group, tenant, datumIds, false);
    }

    @Override
    public Page<ConfigInfo> findAllConfigInfo(int pageNo, int pageSize, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT COUNT(*) FROM config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM ( SELECT id FROM config_info  WHERE tenant_id like ? ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigKey> findAllConfigKey(int pageNo, int pageSize, String tenant) {
        int pageCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String select = " SELECT data_id,group_id,app_name FROM  ( SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?, ? ) g, config_info t  WHERE g.id = t.id ";
        int totalCount = this.configInfoCount(tenant);
        if (totalCount > pageSize * (pageCount = totalCount / pageSize)) {
            ++pageCount;
        }
        if (pageNo > pageCount) {
            return null;
        }
        Page<ConfigKey> page = new Page<ConfigKey>();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(totalCount);
        List<ConfigKey> result = this.databaseOperate.queryMany(" SELECT data_id,group_id,app_name FROM  ( SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?, ? ) g, config_info t  WHERE g.id = t.id ", new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, RowMapperManager.CONFIG_KEY_ROW_MAPPER);
        for (ConfigKey item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page<ConfigInfoBase> findAllConfigInfoBase(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info";
        String sqlFetchRows = "SELECT t.id,data_id,group_id,content,md5  FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,? )   g, config_info t WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "select count(*) from config_info";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified  FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, EMPTY_ARRAY, pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize) {
        String select = "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,type from config_info where id > ? order by id asc limit ?,?";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(select, new Object[]{lastMaxId, 0, pageSize}, 1, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_beta";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5,gmt_modified,beta_ips  FROM (  SELECT id FROM config_info_beta ORDER BY id LIMIT ?,?  ) g, config_info_beta t WHERE g.id = t.id  ";
        PaginationHelper<ConfigInfoBetaWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_tag";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,tag_id,app_name,content,md5,gmt_modified  FROM ( SELECT id FROM config_info_tag  ORDER BY id LIMIT ?,? )  g, config_info_tag t  WHERE g.id = t.id ";
        PaginationHelper<ConfigInfoTagWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfo> findConfigInfoByBatch(List<String> dataIds, String group, String tenant, int subQueryLimit) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        if (subQueryLimit > 50) {
            subQueryLimit = 50;
        }
        ArrayList<ConfigInfo> result = new ArrayList<ConfigInfo>(dataIds.size());
        String sqlStart = "select data_id, group_id, tenant_id, app_name, content from config_info where group_id = ? and tenant_id = ? and data_id in (";
        String sqlEnd = ")";
        StringBuilder subQuerySql = new StringBuilder();
        for (int i = 0; i < dataIds.size(); i += subQueryLimit) {
            ArrayList<String> params = new ArrayList<String>(dataIds.subList(i, Math.min(i + subQueryLimit, dataIds.size())));
            for (int j = 0; j < params.size(); ++j) {
                subQuerySql.append("?");
                if (j == params.size() - 1) continue;
                subQuerySql.append(",");
            }
            params.add(0, group);
            params.add(1, tenantTmp);
            String sql = sqlStart + subQuerySql.toString() + sqlEnd;
            List<ConfigInfo> r = this.databaseOperate.queryMany(sql, params.toArray(), RowMapperManager.CONFIG_INFO_ROW_MAPPER);
            if (r == null || r.size() <= 0) continue;
            result.addAll(r);
        }
        return result;
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, String dataId, String group, String tenant, String appName, String content) {
        String tenantTmp;
        String string = tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            if (StringUtils.isBlank((CharSequence)appName)) {
                return this.findAllConfigInfo(pageNo, pageSize, tenantTmp);
            }
            return this.findConfigInfoByApp(pageNo, pageSize, tenantTmp, appName);
        }
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info where ";
        String where = " 1=1 ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        where = where + " and tenant_id like ? ";
        params.add(this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " and app_name = ? ";
            params.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " and content like ? ";
            params.add(this.generateLikeArgument(content));
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where " + where, "select ID,data_id,group_id,tenant_id,app_name,content from config_info where " + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info where ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfo> page = new Page<ConfigInfo>();
            page.setTotalCount(0);
            return page;
        }
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfo : configKeys) {
            boolean isFirstSub;
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String appName = configInfo.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" and ");
                } else {
                    where.append(" and ");
                }
                where.append("(");
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id not like ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" or ");
                    }
                    where.append(" group_id not like ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" or ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" and ");
            } else {
                where.append(" or ");
            }
            where.append("(");
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" and ");
                }
                where.append(" group_id like ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" and ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where.toString(), sqlFetchRows + where.toString(), params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("appName");
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("content");
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sqlCountRows = "select count(*) from config_info";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,app_name,content from config_info";
        StringBuilder where = new StringBuilder(" where ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.generateLikeArgument(tenantTmp));
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            sqlCountRows = "select count(*) from config_info  a left join config_tags_relation b on a.id=b.id ";
            sqlFetchRows = "select a.ID,a.data_id,a.group_id,a.tenant_id,a.app_name,a.content from config_info  a left join config_tags_relation b on a.id=b.id ";
            where.append(" a.tenant_id like ? ");
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" and a.data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                where.append(" and a.group_id like ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                where.append(" and a.app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((CharSequence)content)) {
                where.append(" and a.content like ? ");
                params.add(this.generateLikeArgument(content));
            }
            where.append(" and b.tag_name in (");
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append("?");
                params.add(tagArr[i]);
            }
            where.append(") ");
        } else {
            where.append(" tenant_id like ? ");
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" and data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                where.append(" and group_id like ? ");
                params.add(this.generateLikeArgument(group));
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                where.append(" and app_name = ? ");
                params.add(appName);
            }
            if (!StringUtils.isBlank((CharSequence)content)) {
                where.append(" and content like ? ");
                params.add(this.generateLikeArgument(content));
            }
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseLike(int pageNo, int pageSize, String dataId, String group, String content) throws IOException {
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            throw new IOException("invalid param");
        }
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select ID,data_id,group_id,tenant_id,content from config_info where ";
        String where = " 1=1 and tenant_id='' ";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " and content like ? ";
            params.add(this.generateLikeArgument(content));
        }
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where " + where, "select ID,data_id,group_id,tenant_id,content from config_info where " + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public ConfigInfoAggr findSingleConfigInfoAggr(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT id,data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? AND datum_id=?";
        return this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, datumId}, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoAggr> findConfigInfoAggr(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE data_id=? AND group_id=? AND tenant_id=? ORDER BY datum_id";
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "SELECT COUNT(*) FROM config_info_aggr WHERE data_id = ? and group_id = ? and tenant_id = ?";
        String sqlFetchRows = "select data_id,group_id,tenant_id,datum_id,app_name,content from config_info_aggr where data_id=? and group_id=? and tenant_id=? order by datum_id limit ?,?";
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, new Object[]{dataId, group, tenantTmp, (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "select count(*) from config_info_aggr where ";
        String sqlFetchRows = "select data_id,group_id,tenant_id,datum_id,app_name,content from config_info_aggr where ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfoAggr> page = new Page<ConfigInfoAggr>();
            page.setTotalCount(0);
            return page;
        }
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfoAggr : configKeys) {
            boolean isFirstSub;
            String dataId = configInfoAggr.getDataId();
            String group = configInfoAggr.getGroup();
            String appName = configInfoAggr.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" and ");
                } else {
                    where.append(" and ");
                }
                where.append("(");
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id not like ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" or ");
                    }
                    where.append(" group_id not like ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" or ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" and ");
            } else {
                where.append(" or ");
            }
            where.append("(");
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id like ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" and ");
                }
                where.append(" group_id like ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" and ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where.toString(), sqlFetchRows + where.toString(), params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoChanged> findAllAggrGroup() {
        String sql = "SELECT DISTINCT data_id, group_id, tenant_id FROM config_info_aggr";
        return this.databaseOperate.queryMany(sql, EMPTY_ARRAY, RowMapperManager.CONFIG_INFO_CHANGED_ROW_MAPPER);
    }

    @Override
    public List<String> findDatumIdByContent(String dataId, String groupId, String content) {
        String sql = "SELECT datum_id FROM config_info_aggr WHERE data_id = ? AND group_id = ? AND content = ? ";
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, groupId, content}, String.class);
    }

    @Override
    public List<ConfigInfoWrapper> findChangeConfig(Timestamp startTime, Timestamp endTime) {
        List<Map<String, Object>> list = this.databaseOperate.queryMany("SELECT data_id, group_id, tenant_id, app_name, content, gmt_modified FROM config_info WHERE gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
        return this.convertChangeConfig(list);
    }

    @Override
    public Page<ConfigInfoWrapper> findChangeConfig(String dataId, String group, String tenant, String appName, Timestamp startTime, Timestamp endTime, int pageNo, int pageSize, long lastMaxId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "select count(*) from config_info where ";
        String sqlFetchRows = "select id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified from config_info where ";
        String where = " 1=1 ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " and data_id like ? ";
            params.add(this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " and group_id like ? ";
            params.add(this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = where + " and tenant_id = ? ";
            params.add(tenantTmp);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = where + " and app_name = ? ";
            params.add(appName);
        }
        if (startTime != null) {
            where = where + " and gmt_modified >=? ";
            params.add(startTime);
        }
        if (endTime != null) {
            where = where + " and gmt_modified <=? ";
            params.add(endTime);
        }
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        return helper.fetchPage("select count(*) from config_info where " + where, "select id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_modified from config_info where " + where, params.toArray(), pageNo, pageSize, lastMaxId, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfo> findDeletedConfig(Timestamp startTime, Timestamp endTime) {
        List<Map<String, Object>> list = this.databaseOperate.queryMany("SELECT DISTINCT data_id, group_id, tenant_id FROM his_config_info WHERE op_type = 'D' AND gmt_modified >=? AND gmt_modified <= ?", new Object[]{startTime, endTime});
        return this.convertDeletedConfig(list);
    }

    @Override
    public long addConfigInfoAtomic(long id, String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String sql = "INSERT INTO config_info(id, data_id, group_id, tenant_id, app_name, content, md5, src_ip, src_user, gmt_create,gmt_modified, c_desc, c_use, effect, type, c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Object[] args = new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, time, desc, use, effect, type, schema};
        EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_info(id, data_id, group_id, tenant_id, app_name, content, md5, src_ip, src_user, gmt_create,gmt_modified, c_desc, c_use, effect, type, c_schema) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", args);
        return id;
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        String sql = "INSERT INTO config_tags_relation(id,tag_name,tag_type,data_id,group_id,tenant_id) VALUES(?,?,?,?,?,?)";
        Object[] args = new Object[]{configId, tagName, null, dataId, group, tenant};
        EmbeddedStorageContextUtils.addSqlContext("INSERT INTO config_tags_relation(id,tag_name,tag_type,data_id,group_id,tenant_id) VALUES(?,?,?,?,?,?)", args);
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        String sql = "DELETE FROM config_tags_relation WHERE id=?";
        Object[] args = new Object[]{id};
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_tags_relation WHERE id=?", args);
    }

    @Override
    public List<String> getConfigTagsByTenant(String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE tenant_id = ? ";
        return this.databaseOperate.queryMany(sql, new Object[]{tenant}, String.class);
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        String sql = "SELECT tag_name FROM config_tags_relation WHERE data_id=? AND group_id=? AND tenant_id = ? ";
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenant}, String.class);
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "DELETE FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?";
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", args);
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM config_info WHERE ");
        sql.append("id in (");
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            paramList.add(Long.parseLong(tagArr[i]));
        }
        sql.append(") ");
        EmbeddedStorageContextUtils.addSqlContext(sql.toString(), paramList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag;
        String sql = "DELETE FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?";
        Object[] args = new Object[]{dataId, group, tenantTmp, tagTmp};
        EmbeddedStorageContextUtils.onDeleteConfigTagInfo(tenantTmp, group, dataId, tagTmp, srcIp);
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM config_info_tag WHERE data_id=? AND group_id=? AND tenant_id=? AND tag_id=?", args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String sql = "UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=?";
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=?", args);
    }

    private void updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String sql = "UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? or md5 is null or md5='')";
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()};
        EmbeddedStorageContextUtils.addSqlContext("UPDATE config_info SET content=?, md5 = ?, src_ip=?,src_user=?,gmt_modified=?,app_name=?,c_desc=?,c_use=?,effect=?,type=?,c_schema=? WHERE data_id=? AND group_id=? AND tenant_id=? AND (md5=? or md5 is null or md5='')", args);
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        StringBuilder sql = new StringBuilder("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5 FROM config_info WHERE ");
        sql.append("id in (");
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            paramList.add(Long.parseLong(tagArr[i]));
        }
        sql.append(") ");
        return this.databaseOperate.queryMany(sql.toString(), paramList.toArray(), RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigAdvanceInfo configAdvance = this.databaseOperate.queryOne("SELECT gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_ADVANCE_INFO_ROW_MAPPER);
        if (CollectionUtils.isNotEmpty(configTagList)) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(",").append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?";
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigAllInfo configAdvance = this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,type,c_schema FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
        if (configTagList != null && !configTagList.isEmpty()) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(",").append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public void insertConfigHistoryAtomic(long configHistoryId, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String sql = "INSERT INTO his_config_info (id,data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_modified,op_type) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
        Object[] args = new Object[]{configHistoryId, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops};
        EmbeddedStorageContextUtils.addSqlContext("INSERT INTO his_config_info (id,data_id,group_id,tenant_id,app_name,content,md5,src_ip,src_user,gmt_modified,op_type) VALUES(?,?,?,?,?,?,?,?,?,?,?)", args);
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sqlCountRows = "select count(*) from his_config_info where data_id = ? and group_id = ? and tenant_id = ?";
        String sqlFetchRows = "select nid,data_id,group_id,tenant_id,app_name,src_ip,src_user,op_type,gmt_create,gmt_modified from his_config_info where data_id = ? and group_id = ? and tenant_id = ? order by nid desc";
        PaginationHelper<ConfigHistoryInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.HISTORY_LIST_ROW_MAPPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigSubAtomic(String dataId, String group, String appName, Timestamp date) {
        String appNameTmp = appName == null ? "" : appName;
        long id = this.idGeneratorManager.nextId(RESOURCE_APP_CONFIGDATA_RELATION_SUBS);
        String sql = "INSERT INTO app_configdata_relation_subs(id, data_id,group_id,app_name,gmt_modified) VALUES(?,?,?,?,?)";
        Object[] args = new Object[]{id, dataId, group, appNameTmp, date};
        EmbeddedStorageContextUtils.addSqlContext("INSERT INTO app_configdata_relation_subs(id, data_id,group_id,app_name,gmt_modified) VALUES(?,?,?,?,?)", args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigSubAtomic(String dataId, String group, String appName, Timestamp time) {
        String appNameTmp = appName == null ? "" : appName;
        String sql = "UPDATE app_configdata_relation_subs SET gmt_modified=? WHERE data_id=? AND group_id=? AND app_name=?";
        Object[] args = new Object[]{time, dataId, group, appNameTmp};
        EmbeddedStorageContextUtils.addSqlContext("UPDATE app_configdata_relation_subs SET gmt_modified=? WHERE data_id=? AND group_id=? AND app_name=?", args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,gmt_create,gmt_modified FROM his_config_info WHERE nid = ?";
        return this.databaseOperate.queryOne(sqlFetchRows, new Object[]{nid}, RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        String sqlFetchRows = "SELECT nid,data_id,group_id,tenant_id,app_name,content,md5,src_user,src_ip,op_type,gmt_create,gmt_modified FROM his_config_info WHERE nid = (select max(nid) from his_config_info where id = ?)";
        return this.databaseOperate.queryOne(sqlFetchRows, new Object[]{id}, RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTenantInfoAtomic(String kp, String tenantId, String tenantName, String tenantDesc, String createResoure, long time) {
        String sql = "INSERT INTO tenant_info(kp,tenant_id,tenant_name,tenant_desc,create_source,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?)";
        Object[] args = new Object[]{kp, tenantId, tenantName, tenantDesc, createResoure, time, time};
        EmbeddedStorageContextUtils.addSqlContext("INSERT INTO tenant_info(kp,tenant_id,tenant_name,tenant_desc,create_source,gmt_create,gmt_modified) VALUES(?,?,?,?,?,?,?)", args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Namespace creation failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTenantNameAtomic(String kp, String tenantId, String tenantName, String tenantDesc) {
        String sql = "UPDATE tenant_info SET tenant_name = ?, tenant_desc = ?, gmt_modified= ? WHERE kp=? AND tenant_id=?";
        Object[] args = new Object[]{tenantName, tenantDesc, System.currentTimeMillis(), kp, tenantId};
        EmbeddedStorageContextUtils.addSqlContext("UPDATE tenant_info SET tenant_name = ?, tenant_desc = ?, gmt_modified= ? WHERE kp=? AND tenant_id=?", args);
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Namespace update failed");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<TenantInfo> findTenantByKp(String kp) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=?";
        return this.databaseOperate.queryMany(sql, new Object[]{kp}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
    }

    @Override
    public TenantInfo findTenantByKp(String kp, String tenantId) {
        String sql = "SELECT tenant_id,tenant_name,tenant_desc FROM tenant_info WHERE kp=? AND tenant_id=?";
        return this.databaseOperate.queryOne(sql, new Object[]{kp, tenantId}, RowMapperManager.TENANT_INFO_ROW_MAPPER);
    }

    @Override
    public void removeTenantInfoAtomic(String kp, String tenantId) {
        EmbeddedStorageContextUtils.addSqlContext("DELETE FROM tenant_info WHERE kp=? AND tenant_id=?", kp, tenantId);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> convertChangeConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfoWrapper> configs = new ArrayList<ConfigInfoWrapper>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            String content = (String)map.get("content");
            long mTime = ((Timestamp)map.get("gmt_modified")).getTime();
            ConfigInfoWrapper config = new ConfigInfoWrapper();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            config.setContent(content);
            config.setLastModified(mTime);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> listAllGroupKeyMd5() {
        int pageSize = 10000;
        int totalCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)totalCount * 1.0 / 10000.0);
        ArrayList<ConfigInfoWrapper> allConfigInfo = new ArrayList<ConfigInfoWrapper>();
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            List<ConfigInfoWrapper> configInfoList = this.listGroupKeyMd5ByPage(pageNo, 10000);
            allConfigInfo.addAll(configInfoList);
        }
        return allConfigInfo;
    }

    @Override
    public List<ConfigInfoWrapper> listGroupKeyMd5ByPage(int pageNo, int pageSize) {
        String sqlCountRows = " SELECT COUNT(*) FROM config_info ";
        String sqlFetchRows = " SELECT t.id,data_id,group_id,tenant_id,app_name,type,md5,gmt_modified FROM ( SELECT id FROM config_info ORDER BY id LIMIT ?,?  ) g, config_info t WHERE g.id = t.id";
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        Page<ConfigInfoWrapper> page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        return page.getPageItems();
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public ConfigInfoWrapper queryConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = "SELECT ID,data_id,group_id,tenant_id,app_name,content,type,gmt_modified,md5 FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?";
        return this.databaseOperate.queryOne("SELECT ID,data_id,group_id,tenant_id,app_name,content,type,gmt_modified,md5 FROM config_info WHERE data_id=? AND group_id=? AND tenant_id=?", new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public boolean isExistTable(String tableName) {
        String sql = String.format("SELECT 1 FROM %s FETCH FIRST ROW ONLY", tableName);
        try {
            this.databaseOperate.queryOne(sql, Integer.class);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Boolean completeMd5() {
        LogUtil.DEFAULT_LOG.info("[start completeMd5]");
        int perPageSize = 1000;
        int rowCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)perPageSize);
        int actualRowCount = 0;
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            Page<ConfigInfoWrapper> page = this.findAllConfigInfoForDumpAll(pageNo, perPageSize);
            if (page == null) continue;
            for (ConfigInfoWrapper cf : page.getPageItems()) {
                String md5InDb = cf.getMd5();
                String content = cf.getContent();
                String tenant = cf.getTenant();
                String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
                if (StringUtils.isBlank((CharSequence)md5InDb)) {
                    try {
                        this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                    }
                    catch (Throwable e) {
                        LogUtil.DEFAULT_LOG.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                    }
                    continue;
                }
                if (md5InDb.equals(md5)) continue;
                try {
                    this.updateMd5(cf.getDataId(), cf.getGroup(), tenant, md5, new Timestamp(cf.getLastModified()));
                }
                catch (Throwable e) {
                    LogUtil.DEFAULT_LOG.error("[completeMd5-error] datId:{} group:{} lastModified:{}", new Object[]{cf.getDataId(), cf.getGroup(), new Timestamp(cf.getLastModified())});
                }
            }
            LogUtil.DEFAULT_LOG.info("[completeMd5] {} / {}", (Object)(actualRowCount += page.getPageItems().size()), (Object)rowCount);
        }
        return true;
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder where = new StringBuilder(" where ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(ids)) {
            where.append(" id in (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    where.append(", ");
                }
                where.append("?");
                paramList.add(ids.get(i));
            }
            where.append(") ");
        } else {
            where.append(" tenant_id=? ");
            paramList.add(tenantTmp);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" and data_id like ? ");
                paramList.add(this.generateLikeArgument(dataId));
            }
            if (StringUtils.isNotBlank((CharSequence)group)) {
                where.append(" and group_id=? ");
                paramList.add(group);
            }
            if (StringUtils.isNotBlank((CharSequence)appName)) {
                where.append(" and app_name=? ");
                paramList.add(appName);
            }
        }
        return this.databaseOperate.queryMany("select id,data_id,group_id,tenant_id,app_name,content,type,md5,gmt_create,gmt_modified,src_user,src_ip,c_desc,c_use,effect,c_schema from config_info" + where, paramList.toArray(), RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, Timestamp time, boolean notify, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        BiConsumer<Boolean, Throwable> callFinally = (result, t) -> {
            if (t != null) {
                throw new NacosRuntimeException(0, t);
            }
        };
        for (int i = 0; i < configInfoList.size(); ++i) {
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (Throwable e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            String type = configInfo.getType();
            if (StringUtils.isBlank((CharSequence)type) && configInfo.getDataId().contains(".")) {
                String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(".") + 1);
                FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                type = fileTypeEnum.getFileType();
            }
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                this.addConfigInfo(srcIp, srcUser, configInfo2Save, time, configAdvanceInfo, notify, callFinally);
                ++succCount;
                continue;
            }
            catch (Throwable e) {
                if (!StringUtils.contains((CharSequence)e.toString(), (CharSequence)"DuplicateKeyException")) {
                    throw e;
                }
                if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                    failData = new ArrayList();
                    skipData = new ArrayList();
                    HashMap<String, String> faileditem = new HashMap<String, String>(2);
                    faileditem.put("dataId", configInfo2Save.getDataId());
                    faileditem.put("group", configInfo2Save.getGroup());
                    failData.add(faileditem);
                    for (int j = i + 1; j < configInfoList.size(); ++j) {
                        ConfigInfo skipConfigInfo = configInfoList.get(j);
                        HashMap<String, String> skipitem = new HashMap<String, String>(2);
                        skipitem.put("dataId", skipConfigInfo.getDataId());
                        skipitem.put("group", skipConfigInfo.getGroup());
                        skipData.add(skipitem);
                    }
                    break;
                }
                if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                    ++skipCount;
                    if (skipData == null) {
                        skipData = new ArrayList();
                    }
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put("dataId", configInfo2Save.getDataId());
                    skipitem.put("group", configInfo2Save.getGroup());
                    skipData.add(skipitem);
                    continue;
                }
                if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
                ++succCount;
                this.updateConfigInfo(configInfo2Save, srcIp, srcUser, time, configAdvanceInfo, notify);
            }
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>(4);
        result2.put("succCount", succCount);
        result2.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result2.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result2.put("skipData", skipData);
        }
        return result2;
    }

    @Override
    public int tenantInfoCountByTenantId(String tenantId) {
        Assert.hasText((String)tenantId, (String)"tenantId can not be null");
        Integer result = this.databaseOperate.queryOne("select count(1) from tenant_info where tenant_id = ?", (Object[])new String[]{tenantId}, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }
}

