/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.config.server.auth.ConfigResourceParser;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.control.TpsControl;
import com.alibaba.nacos.core.utils.Loggers;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfigRemoveRequestHandler
extends RequestHandler<ConfigRemoveRequest, ConfigRemoveResponse> {
    private final PersistService persistService;

    public ConfigRemoveRequestHandler(PersistService persistService) {
        this.persistService = persistService;
    }

    @TpsControl(pointName="ConfigRemove")
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public ConfigRemoveResponse handle(ConfigRemoveRequest configRemoveRequest, RequestMeta meta) throws NacosException {
        String tenant = configRemoveRequest.getTenant();
        String dataId = configRemoveRequest.getDataId();
        String group = configRemoveRequest.getGroup();
        String tag = configRemoveRequest.getTag();
        try {
            ParamUtils.checkTenant(tenant);
            ParamUtils.checkParam(dataId, group, "datumId", "rm");
            ParamUtils.checkParam(tag);
            String clientIp = meta.getClientIp();
            if (StringUtils.isBlank((CharSequence)tag)) {
                this.persistService.removeConfigInfo(dataId, group, tenant, clientIp, null);
            } else {
                this.persistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, null);
            }
            Timestamp time = TimeUtils.getCurrentTime();
            ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), clientIp, "remove", null);
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
            return ConfigRemoveResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("remove config error,error msg is {}", (Object)e.getMessage(), (Object)e);
            return ConfigRemoveResponse.buildFailResponse((String)e.getMessage());
        }
    }
}

