/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.config.server.auth.ConfigResourceParser;
import com.alibaba.nacos.config.server.model.CacheItem;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.remote.ConfigQueryGroupKeyParser;
import com.alibaba.nacos.config.server.remote.ConfigQueryGroupParser;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.DiskUtil;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.control.TpsControl;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfigQueryRequestHandler
extends RequestHandler<ConfigQueryRequest, ConfigQueryResponse> {
    private static final int TRY_GET_LOCK_TIMES = 9;
    private final PersistService persistService;

    public ConfigQueryRequestHandler(PersistService persistService) {
        this.persistService = persistService;
    }

    @TpsControl(pointName="ConfigQuery", parsers={ConfigQueryGroupKeyParser.class, ConfigQueryGroupParser.class})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public ConfigQueryResponse handle(ConfigQueryRequest request, RequestMeta meta) throws NacosException {
        try {
            ConfigQueryResponse context = this.getContext(request, meta, request.isNotify());
            return context;
        }
        catch (Exception e) {
            ConfigQueryResponse contextFail = ConfigQueryResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)e.getMessage());
            return contextFail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigQueryResponse getContext(ConfigQueryRequest configQueryRequest, RequestMeta meta, boolean notify) throws UnsupportedEncodingException {
        String dataId = configQueryRequest.getDataId();
        String group = configQueryRequest.getGroup();
        String tenant = configQueryRequest.getTenant();
        String clientIp = meta.getClientIp();
        String tag = configQueryRequest.getTag();
        ConfigQueryResponse response = new ConfigQueryResponse();
        String groupKey = GroupKey2.getKey(configQueryRequest.getDataId(), configQueryRequest.getGroup(), configQueryRequest.getTenant());
        String autoTag = configQueryRequest.getHeader("Vipserver-Tag");
        String requestIpApp = (String)meta.getLabels().get("Client-AppName");
        int lockResult = ConfigQueryRequestHandler.tryConfigReadLock(groupKey);
        boolean isBeta = false;
        boolean isSli = false;
        if (lockResult > 0) {
            try {
                String md5 = "";
                long lastModified = 0L;
                CacheItem cacheItem = ConfigCacheService.getContentCache(groupKey);
                if (cacheItem != null) {
                    String configType;
                    if (cacheItem.isBeta() && cacheItem.getIps4Beta().contains(clientIp)) {
                        isBeta = true;
                    }
                    response.setContentType(null != (configType = cacheItem.getType()) ? configType : "text");
                }
                File file = null;
                ConfigInfo configInfoBase = null;
                Object out = null;
                if (isBeta) {
                    md5 = cacheItem.getMd54Beta();
                    lastModified = cacheItem.getLastModifiedTs4Beta();
                    if (PropertyUtil.isDirectRead()) {
                        configInfoBase = this.persistService.findConfigInfo4Beta(dataId, group, tenant);
                    } else {
                        file = DiskUtil.targetBetaFile(dataId, group, tenant);
                    }
                    response.setBeta(true);
                } else if (StringUtils.isBlank((CharSequence)tag)) {
                    if (ConfigQueryRequestHandler.isUseTag(cacheItem, autoTag)) {
                        if (cacheItem != null) {
                            if (cacheItem.tagMd5 != null) {
                                md5 = cacheItem.tagMd5.get(autoTag);
                            }
                            if (cacheItem.tagLastModifiedTs != null) {
                                lastModified = cacheItem.tagLastModifiedTs.get(autoTag);
                            }
                        }
                        if (PropertyUtil.isDirectRead()) {
                            configInfoBase = this.persistService.findConfigInfo4Tag(dataId, group, tenant, autoTag);
                        } else {
                            file = DiskUtil.targetTagFile(dataId, group, tenant, autoTag);
                        }
                        response.setTag(URLEncoder.encode(autoTag, "UTF-8"));
                    } else {
                        md5 = cacheItem.getMd5();
                        lastModified = cacheItem.getLastModifiedTs();
                        if (PropertyUtil.isDirectRead()) {
                            configInfoBase = this.persistService.findConfigInfo(dataId, group, tenant);
                        } else {
                            file = DiskUtil.targetFile(dataId, group, tenant);
                        }
                        if (configInfoBase == null && ConfigQueryRequestHandler.fileNotExist(file)) {
                            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, clientIp, false);
                            response.setErrorInfo(300, "config data not exist");
                            ConfigQueryResponse configQueryResponse = response;
                            return configQueryResponse;
                        }
                    }
                } else {
                    Long lm;
                    if (cacheItem != null) {
                        if (cacheItem.tagMd5 != null) {
                            md5 = cacheItem.tagMd5.get(tag);
                        }
                        if (cacheItem.tagLastModifiedTs != null && (lm = cacheItem.tagLastModifiedTs.get(tag)) != null) {
                            lastModified = lm;
                        }
                    }
                    if (PropertyUtil.isDirectRead()) {
                        configInfoBase = this.persistService.findConfigInfo4Tag(dataId, group, tenant, tag);
                    } else {
                        file = DiskUtil.targetTagFile(dataId, group, tenant, tag);
                    }
                    if (configInfoBase == null && ConfigQueryRequestHandler.fileNotExist(file)) {
                        ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, clientIp, false);
                        response.setErrorInfo(300, "config data not exist");
                        lm = response;
                        return lm;
                    }
                }
                response.setMd5(md5);
                if (PropertyUtil.isDirectRead()) {
                    response.setLastModified(lastModified);
                    response.setContent(configInfoBase.getContent());
                    response.setResultCode(ResponseCode.SUCCESS.getCode());
                } else {
                    String content = null;
                    try {
                        content = ConfigQueryRequestHandler.readFileContent(file);
                        response.setContent(content);
                        response.setLastModified(lastModified);
                        response.setResultCode(ResponseCode.SUCCESS.getCode());
                    }
                    catch (IOException e) {
                        response.setErrorInfo(ResponseCode.FAIL.getCode(), e.getMessage());
                        ConfigQueryResponse configQueryResponse = response;
                        ConfigQueryRequestHandler.releaseConfigReadLock(groupKey);
                        return configQueryResponse;
                    }
                }
                LogUtil.PULL_CHECK_LOG.warn("{}|{}|{}|{}", new Object[]{groupKey, clientIp, md5, TimeUtils.getCurrentTimeStr()});
                long delayed = System.currentTimeMillis() - lastModified;
                ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, lastModified, "ok", notify ? delayed : -1L, clientIp, notify);
            }
            finally {
                ConfigQueryRequestHandler.releaseConfigReadLock(groupKey);
            }
        }
        if (lockResult == 0) {
            ConfigTraceService.logPullEvent(dataId, group, tenant, requestIpApp, -1L, "not-found", -1L, clientIp, notify);
            response.setErrorInfo(300, "config data not exist");
        } else {
            LogUtil.PULL_LOG.info("[client-get] clientIp={}, {}, get data during dump", (Object)clientIp, (Object)groupKey);
            response.setErrorInfo(400, "requested file is being modified, please try later.");
        }
        return response;
    }

    public static String readFileContent(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    private static void releaseConfigReadLock(String groupKey) {
        ConfigCacheService.releaseReadLock(groupKey);
    }

    private static boolean fileNotExist(File file) {
        return file == null || !file.exists();
    }

    private static int tryConfigReadLock(String groupKey) {
        int lockResult = -1;
        for (int i = 9; i >= 0 && 0 != (lockResult = ConfigCacheService.tryReadLock(groupKey)) && lockResult <= 0; --i) {
            if (i <= 0) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                LogUtil.PULL_CHECK_LOG.error("An Exception occurred while thread sleep", (Throwable)e);
            }
        }
        return lockResult;
    }

    private static boolean isUseTag(CacheItem cacheItem, String tag) {
        if (cacheItem != null && cacheItem.tagMd5 != null && cacheItem.tagMd5.size() > 0) {
            return StringUtils.isNotBlank((CharSequence)tag) && cacheItem.tagMd5.containsKey(tag);
        }
        return false;
    }
}

