/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.config.server.auth.ConfigResourceParser;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.remote.ConfigPublishGroupKeyParser;
import com.alibaba.nacos.config.server.remote.ConfigPublishGroupParser;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.control.TpsControl;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfigPublishRequestHandler
extends RequestHandler<ConfigPublishRequest, ConfigPublishResponse> {
    private final PersistService persistService;

    public ConfigPublishRequestHandler(PersistService persistService) {
        this.persistService = persistService;
    }

    @TpsControl(pointName="ConfigPublish", parsers={ConfigPublishGroupKeyParser.class, ConfigPublishGroupParser.class})
    @Secured(action=ActionTypes.WRITE, resource="", parser=ConfigResourceParser.class)
    public ConfigPublishResponse handle(ConfigPublishRequest request, RequestMeta meta) throws NacosException {
        try {
            String dataId = request.getDataId();
            String group = request.getGroup();
            String content = request.getContent();
            String tenant = request.getTenant();
            String srcIp = meta.getClientIp();
            String requestIpApp = request.getAdditionParam("requestIpApp");
            String tag = request.getAdditionParam("tag");
            String appName = request.getAdditionParam("appName");
            String type = request.getAdditionParam("type");
            String srcUser = request.getAdditionParam("src_user");
            ParamUtils.checkParam(dataId, group, "datumId", content);
            ParamUtils.checkParam(tag);
            HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)request.getAdditionParam("config_tags"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)request.getAdditionParam("desc"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)request.getAdditionParam("use"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)request.getAdditionParam("effect"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)type);
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)request.getAdditionParam("schema"));
            ParamUtils.checkParam(configAdvanceInfo);
            if (AggrWhitelist.isAggrDataId(dataId)) {
                Loggers.REMOTE_DIGEST.warn("[aggr-conflict] {} attempt to publish single data, {}, {}", new Object[]{srcIp, dataId, group});
                throw new NacosException(403, "dataId:" + dataId + " is aggr");
            }
            Timestamp time = TimeUtils.getCurrentTime();
            String betaIps = request.getAdditionParam("betaIps");
            ConfigInfo configInfo = new ConfigInfo(dataId, group, tenant, appName, content);
            configInfo.setMd5(request.getCasMd5());
            configInfo.setType(type);
            if (StringUtils.isBlank((CharSequence)betaIps)) {
                if (StringUtils.isBlank((CharSequence)tag)) {
                    if (StringUtils.isNotBlank((CharSequence)request.getCasMd5())) {
                        boolean casSuccess = this.persistService.insertOrUpdateCas(srcIp, srcUser, configInfo, time, configAdvanceInfo, false);
                        if (!casSuccess) {
                            return ConfigPublishResponse.buildFailResponse((String)"Cas publish fail,server md5 may have changed.");
                        }
                    } else {
                        this.persistService.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, false);
                    }
                    ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, time.getTime()));
                } else {
                    if (StringUtils.isNotBlank((CharSequence)request.getCasMd5())) {
                        boolean casSuccess = this.persistService.insertOrUpdateTagCas(configInfo, tag, srcIp, srcUser, time, false);
                        if (!casSuccess) {
                            return ConfigPublishResponse.buildFailResponse((String)"Cas publish tag config fail,server md5 may have changed.");
                        }
                    } else {
                        this.persistService.insertOrUpdateTag(configInfo, tag, srcIp, srcUser, time, false);
                    }
                    ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)request.getCasMd5())) {
                    boolean casSuccess = this.persistService.insertOrUpdateBetaCas(configInfo, betaIps, srcIp, srcUser, time, false);
                    if (!casSuccess) {
                        return ConfigPublishResponse.buildFailResponse((String)"Cas publish beta config fail,server md5 may have changed.");
                    }
                } else {
                    this.persistService.insertOrUpdateBeta(configInfo, betaIps, srcIp, srcUser, time, false);
                }
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(true, dataId, group, tenant, time.getTime()));
            }
            ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, time.getTime(), InetUtils.getSelfIP(), "pub", content);
            return ConfigPublishResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("[ConfigPublishRequestHandler] publish config error ,request ={}", (Object)request, (Object)e);
            return ConfigPublishResponse.buildFailResponse((String)e.getMessage());
        }
    }
}

