/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.config.server.model.event.DerbyLoadEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.datasource.LocalDataSourceServiceImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.raft.utils.RaftExecutor;
import com.alibaba.nacos.core.utils.TimerContext;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import java.io.File;
import java.nio.file.Paths;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.zip.Checksum;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DerbySnapshotOperation
implements SnapshotOperation {
    private static final String DERBY_SNAPSHOT_SAVE = DerbySnapshotOperation.class.getSimpleName() + ".SAVE";
    private static final String DERBY_SNAPSHOT_LOAD = DerbySnapshotOperation.class.getSimpleName() + ".LOAD";
    private final String backupSql = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)";
    private final String snapshotDir = "derby_data";
    private final String snapshotArchive = "derby_data.zip";
    private final String derbyBaseDir = Paths.get(EnvUtil.getNacosHome(), "data", "derby-data").toString();
    private final String restoreDB = "jdbc:derby:" + this.derbyBaseDir;
    private final String checkSumKey = "checkSum";
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public DerbySnapshotOperation(ReentrantReadWriteLock.WriteLock writeLock) {
        this.writeLock = writeLock;
    }

    public void onSnapshotSave(Writer writer, BiConsumer<Boolean, Throwable> callFinally) {
        RaftExecutor.doSnapshot(() -> {
            TimerContext.start((String)DERBY_SNAPSHOT_SAVE);
            ReentrantReadWriteLock.WriteLock lock = this.writeLock;
            lock.lock();
            try {
                String writePath = writer.getPath();
                String parentPath = Paths.get(writePath, "derby_data").toString();
                DiskUtils.deleteDirectory((String)parentPath);
                DiskUtils.forceMkdir((String)parentPath);
                this.doDerbyBackup(parentPath);
                String outputFile = Paths.get(writePath, "derby_data.zip").toString();
                CRC64 checksum = new CRC64();
                DiskUtils.compress((String)writePath, (String)"derby_data", (String)outputFile, (Checksum)checksum);
                DiskUtils.deleteDirectory((String)parentPath);
                LocalFileMeta meta = new LocalFileMeta();
                meta.append((Object)"checkSum", (Object)Long.toHexString(checksum.getValue()));
                callFinally.accept(writer.addFile("derby_data.zip", meta), null);
            }
            catch (Throwable t) {
                LogUtil.FATAL_LOG.error("Fail to compress snapshot, path={}, file list={}, {}.", new Object[]{writer.getPath(), writer.listFiles(), t});
                callFinally.accept(false, t);
            }
            finally {
                lock.unlock();
                TimerContext.end((String)DERBY_SNAPSHOT_SAVE, (Logger)LogUtil.FATAL_LOG);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSnapshotLoad(Reader reader) {
        String readerPath = reader.getPath();
        String sourceFile = Paths.get(readerPath, "derby_data.zip").toString();
        TimerContext.start((String)DERBY_SNAPSHOT_LOAD);
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        lock.lock();
        try {
            CRC64 checksum = new CRC64();
            DiskUtils.decompress((String)sourceFile, (String)readerPath, (Checksum)checksum);
            LocalFileMeta fileMeta = reader.getFileMeta("derby_data.zip");
            if (fileMeta.getFileMeta().containsKey("checkSum") && !Objects.equals(Long.toHexString(checksum.getValue()), fileMeta.get("checkSum"))) {
                throw new IllegalArgumentException("Snapshot checksum failed");
            }
            String loadPath = Paths.get(readerPath, "derby_data", "derby-data").toString();
            LogUtil.FATAL_LOG.info("snapshot load from : {}, and copy to : {}", (Object)loadPath, (Object)this.derbyBaseDir);
            this.doDerbyRestoreFromBackup(() -> {
                File srcDir = new File(loadPath);
                File destDir = new File(this.derbyBaseDir);
                DiskUtils.copyDirectory((File)srcDir, (File)destDir);
                LogUtil.FATAL_LOG.info("Complete database recovery");
                return null;
            });
            DiskUtils.deleteDirectory((String)loadPath);
            NotifyCenter.publishEvent((Event)DerbyLoadEvent.INSTANCE);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LogUtil.FATAL_LOG.error("Fail to load snapshot, path={}, file list={}, {}.", new Object[]{readerPath, reader.listFiles(), t});
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
            TimerContext.end((String)DERBY_SNAPSHOT_LOAD, (Logger)LogUtil.FATAL_LOG);
        }
    }

    private void doDerbyBackup(String backupDirectory) throws Exception {
        DataSourceService sourceService = DynamicDataSource.getInstance().getDataSource();
        DataSource dataSource = sourceService.getJdbcTemplate().getDataSource();
        try (Connection holder = Objects.requireNonNull(dataSource, "dataSource").getConnection();){
            CallableStatement cs = holder.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            cs.setString(1, backupDirectory);
            cs.execute();
        }
    }

    private void doDerbyRestoreFromBackup(Callable<Void> callable) throws Exception {
        DataSourceService sourceService = DynamicDataSource.getInstance().getDataSource();
        LocalDataSourceServiceImpl localDataSourceService = (LocalDataSourceServiceImpl)sourceService;
        localDataSourceService.restoreDerby(this.restoreDB, callable);
    }
}

