/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    static final CopyOnWriteArrayList<Entry> LISTENER_HUB = new CopyOnWriteArrayList();

    public static void addEventListener(AbstractEventListener listener) {
        for (Class<? extends Event> type : listener.interest()) {
            EventDispatcher.getEntry(type).listeners.addIfAbsent(listener);
        }
    }

    public static void fireEvent(Event event) {
        if (null == event) {
            throw new IllegalArgumentException();
        }
        for (AbstractEventListener listener : EventDispatcher.getEntry(event.getClass()).listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void clear() {
        LISTENER_HUB.clear();
    }

    static Entry getEntry(Class<? extends Event> eventType) {
        Entry tmp;
        do {
            for (Entry entry : LISTENER_HUB) {
                if (entry.eventType != eventType) continue;
                return entry;
            }
        } while (!LISTENER_HUB.addIfAbsent(tmp = new Entry(eventType)));
        return tmp;
    }

    public static abstract class AbstractEventListener {
        public AbstractEventListener() {
            EventDispatcher.addEventListener(this);
        }

        public abstract List<Class<? extends Event>> interest();

        public abstract void onEvent(Event var1);
    }

    public static interface Event {
    }

    private static class Entry {
        final Class<? extends Event> eventType;
        final CopyOnWriteArrayList<AbstractEventListener> listeners;

        Entry(Class<? extends Event> type) {
            this.eventType = type;
            this.listeners = new CopyOnWriteArrayList();
        }

        public boolean equals(Object obj) {
            if (null == obj || obj.getClass() != this.getClass()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.eventType == ((Entry)obj).eventType;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

