/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5;
import java.sql.Timestamp;
import java.util.List;

class DumpChangeProcessor
implements TaskProcessor {
    final DumpService dumpService;
    final PersistService persistService;
    final Timestamp startTime;
    final Timestamp endTime;

    DumpChangeProcessor(DumpService dumpService, Timestamp startTime, Timestamp endTime) {
        this.dumpService = dumpService;
        this.persistService = dumpService.persistService;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        LogUtil.defaultLog.warn("quick start; startTime:{},endTime:{}", (Object)this.startTime, (Object)this.endTime);
        LogUtil.defaultLog.warn("updateMd5 start");
        long startUpdateMd5 = System.currentTimeMillis();
        List<PersistService.ConfigInfoWrapper> updateMd5List = this.persistService.listAllGroupKeyMd5();
        LogUtil.defaultLog.warn("updateMd5 count:{}", (Object)updateMd5List.size());
        for (PersistService.ConfigInfoWrapper config : updateMd5List) {
            String groupKey = GroupKey2.getKey(config.getDataId(), config.getGroup());
            ConfigService.updateMd5(groupKey, config.getMd5(), config.getLastModified());
        }
        long endUpdateMd5 = System.currentTimeMillis();
        LogUtil.defaultLog.warn("updateMd5 done,cost:{}", (Object)(endUpdateMd5 - startUpdateMd5));
        LogUtil.defaultLog.warn("deletedConfig start");
        long startDeletedConfigTime = System.currentTimeMillis();
        List<ConfigInfo> configDeleted = this.persistService.findDeletedConfig(this.startTime, this.endTime);
        LogUtil.defaultLog.warn("deletedConfig count:{}", (Object)configDeleted.size());
        for (ConfigInfo configInfo : configDeleted) {
            if (this.persistService.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) != null) continue;
            ConfigService.remove(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
        }
        long endDeletedConfigTime = System.currentTimeMillis();
        LogUtil.defaultLog.warn("deletedConfig done,cost:{}", (Object)(endDeletedConfigTime - startDeletedConfigTime));
        LogUtil.defaultLog.warn("changeConfig start");
        long startChangeConfigTime = System.currentTimeMillis();
        List<PersistService.ConfigInfoWrapper> changeConfigs = this.persistService.findChangeConfig(this.startTime, this.endTime);
        LogUtil.defaultLog.warn("changeConfig count:{}", (Object)changeConfigs.size());
        for (PersistService.ConfigInfoWrapper cf : changeConfigs) {
            boolean result = ConfigService.dumpChange(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified());
            String content = cf.getContent();
            String md5 = MD5.getInstance().getMD5String(content);
            LogUtil.defaultLog.info("[dump-change-ok] {}, {}, length={}, md5={}", new Object[]{GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), content.length(), md5});
        }
        ConfigService.reloadConfig();
        long endChangeConfigTime = System.currentTimeMillis();
        LogUtil.defaultLog.warn("changeConfig done,cost:{}", (Object)(endChangeConfigTime - startChangeConfigTime));
        return true;
    }
}

