/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.MD5;

class DumpAllProcessor
implements TaskProcessor {
    static final int PAGE_SIZE = 1000;
    final DumpService dumpService;
    final PersistService persistService;

    DumpAllProcessor(DumpService dumpService) {
        this.dumpService = dumpService;
        this.persistService = dumpService.persistService;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        long currentMaxId = this.persistService.findConfigMaxId();
        long lastMaxId = 0L;
        while (lastMaxId < currentMaxId) {
            Page<PersistService.ConfigInfoWrapper> page = this.persistService.findAllConfigInfoFragment(lastMaxId, 1000);
            if (page != null && page.getPageItems() != null) {
                for (PersistService.ConfigInfoWrapper cf : page.getPageItems()) {
                    long id = cf.getId();
                    long l = lastMaxId = id > lastMaxId ? id : lastMaxId;
                    if (cf.getDataId().equals("com.alibaba.nacos.metadata.aggrIDs")) {
                        AggrWhitelist.load(cf.getContent());
                    }
                    if (cf.getDataId().equals("com.alibaba.nacos.metadata.clientIpWhitelist")) {
                        ClientIpWhiteList.load(cf.getContent());
                    }
                    if (cf.getDataId().equals("com.alibaba.nacos.meta.switch")) {
                        SwitchService.load(cf.getContent());
                    }
                    boolean result = ConfigService.dump(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified());
                    String content = cf.getContent();
                    String md5 = MD5.getInstance().getMD5String(content);
                    LogUtil.dumpLog.info("[dump-all-ok] {}, {}, length={}, md5={}", new Object[]{GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), content.length(), md5});
                }
                LogUtil.defaultLog.info("[all-dump] {} / {}", (Object)lastMaxId, (Object)currentMaxId);
                continue;
            }
            lastMaxId += 1000L;
        }
        return true;
    }
}

