/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.capacity;

import com.alibaba.nacos.config.server.constant.CounterMode;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.capacity.GroupCapacity;
import com.alibaba.nacos.config.server.model.capacity.TenantCapacity;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.capacity.GroupCapacityPersistService;
import com.alibaba.nacos.config.server.service.capacity.TenantCapacityPersistService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class CapacityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityService.class);
    private static final Integer ZERO = 0;
    private static final int INIT_PAGE_SIZE = 500;
    @Autowired
    private GroupCapacityPersistService groupCapacityPersistService;
    @Autowired
    private TenantCapacityPersistService tenantCapacityPersistService;
    @Autowired
    private PersistService persistService;
    private ScheduledExecutorService scheduledExecutorService;

    @PostConstruct
    public void init() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("com.alibaba.nacos.CapacityManagement-%d").setDaemon(true).build();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("[capacityManagement] start correct usage");
                Stopwatch stopwatch = Stopwatch.createStarted();
                CapacityService.this.correctUsage();
                LOGGER.info("[capacityManagement] end correct usage, cost: {}s", (Object)stopwatch.elapsed(TimeUnit.SECONDS));
            }
        }, PropertyUtil.getCorrectUsageDelay(), PropertyUtil.getCorrectUsageDelay(), TimeUnit.SECONDS);
    }

    @PreDestroy
    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    public void correctUsage() {
        this.correctGroupUsage();
        this.correctTenantUsage();
    }

    public void correctGroupUsage(String group) {
        this.groupCapacityPersistService.correctUsage(group, TimeUtils.getCurrentTime());
    }

    public void correctTenantUsage(String tenant) {
        this.tenantCapacityPersistService.correctUsage(tenant, TimeUtils.getCurrentTime());
    }

    public void initAllCapacity() {
        this.initAllCapacity(false);
        this.initAllCapacity(true);
    }

    private void initAllCapacity(boolean isTenant) {
        int page = 1;
        while (true) {
            List<String> list = isTenant ? this.persistService.getTenantIdList(page, 500) : this.persistService.getGroupIdList(page, 500);
            for (String targetId : list) {
                if (isTenant) {
                    this.insertTenantCapacity(targetId);
                    this.autoExpansion(null, targetId);
                    continue;
                }
                this.insertGroupCapacity(targetId);
                this.autoExpansion(targetId, null);
            }
            if (list.size() < 500) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++page;
        }
    }

    private void correctGroupUsage() {
        List<GroupCapacity> groupCapacityList;
        long lastId = 0L;
        int pageSize = 100;
        while (!(groupCapacityList = this.groupCapacityPersistService.getCapacityList4CorrectUsage(lastId, pageSize)).isEmpty()) {
            lastId = groupCapacityList.get(groupCapacityList.size() - 1).getId();
            for (GroupCapacity groupCapacity : groupCapacityList) {
                String group = groupCapacity.getGroup();
                this.groupCapacityPersistService.correctUsage(group, TimeUtils.getCurrentTime());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void correctTenantUsage() {
        List<TenantCapacity> tenantCapacityList;
        long lastId = 0L;
        int pageSize = 100;
        while (!(tenantCapacityList = this.tenantCapacityPersistService.getCapacityList4CorrectUsage(lastId, pageSize)).isEmpty()) {
            lastId = tenantCapacityList.get(tenantCapacityList.size() - 1).getId();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (TenantCapacity tenantCapacity : tenantCapacityList) {
                String tenant = tenantCapacity.getTenant();
                this.tenantCapacityPersistService.correctUsage(tenant, TimeUtils.getCurrentTime());
            }
        }
    }

    public boolean insertAndUpdateClusterUsage(CounterMode counterMode, boolean ignoreQuotaLimit) {
        Capacity capacity = this.groupCapacityPersistService.getClusterCapacity();
        if (capacity == null) {
            this.insertGroupCapacity("");
        }
        return this.updateGroupUsage(counterMode, "", PropertyUtil.getDefaultClusterQuota(), ignoreQuotaLimit);
    }

    public boolean updateClusterUsage(CounterMode counterMode) {
        return this.updateGroupUsage(counterMode, "", PropertyUtil.getDefaultClusterQuota(), false);
    }

    public boolean insertAndUpdateGroupUsage(CounterMode counterMode, String group, boolean ignoreQuotaLimit) {
        GroupCapacity groupCapacity = this.getGroupCapacity(group);
        if (groupCapacity == null) {
            this.initGroupCapacity(group, null, null, null, null);
        }
        return this.updateGroupUsage(counterMode, group, PropertyUtil.getDefaultGroupQuota(), ignoreQuotaLimit);
    }

    public GroupCapacity getGroupCapacity(String group) {
        return this.groupCapacityPersistService.getGroupCapacity(group);
    }

    public boolean updateGroupUsage(CounterMode counterMode, String group) {
        return this.updateGroupUsage(counterMode, group, PropertyUtil.getDefaultGroupQuota(), false);
    }

    public boolean initGroupCapacity(String group) {
        return this.initGroupCapacity(group, null, null, null, null);
    }

    private boolean initGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        boolean insertSuccess = this.insertGroupCapacity(group, quota, maxSize, maxAggrCount, maxAggrSize);
        if (quota != null) {
            return insertSuccess;
        }
        this.autoExpansion(group, null);
        return insertSuccess;
    }

    private void autoExpansion(String group, String tenant) {
        Capacity capacity = this.getCapacity(group, tenant);
        int defaultQuota = this.getDefaultQuota(tenant != null);
        Integer usage = capacity.getUsage();
        if (usage < defaultQuota) {
            return;
        }
        int initialExpansionPercent = PropertyUtil.getInitialExpansionPercent();
        if (initialExpansionPercent > 0) {
            int finalQuota = (int)((double)usage.intValue() + (double)defaultQuota * (1.0 * (double)initialExpansionPercent / 100.0));
            if (tenant != null) {
                this.tenantCapacityPersistService.updateQuota(tenant, finalQuota);
                LogUtil.defaultLog.warn("[capacityManagement] \u521d\u59cb\u5316\u7684\u65f6\u5019\u8be5\u79df\u6237\uff08{}\uff09\u4f7f\u7528\u91cf\uff08{}\uff09\u5c31\u5df2\u7ecf\u5230\u8fbe\u9650\u989d{}\uff0c\u81ea\u52a8\u6269\u5bb9\u5230{}", new Object[]{tenant, usage, defaultQuota, finalQuota});
            } else {
                this.groupCapacityPersistService.updateQuota(group, finalQuota);
                LogUtil.defaultLog.warn("[capacityManagement] \u521d\u59cb\u5316\u7684\u65f6\u5019\u8be5Group\uff08{}\uff09\u4f7f\u7528\u91cf\uff08{}\uff09\u5c31\u5df2\u7ecf\u5230\u8fbe\u9650\u989d{}\uff0c\u81ea\u52a8\u6269\u5bb9\u5230{}", new Object[]{group, usage, defaultQuota, finalQuota});
            }
        }
    }

    private int getDefaultQuota(boolean isTenant) {
        if (isTenant) {
            return PropertyUtil.getDefaultTenantQuota();
        }
        return PropertyUtil.getDefaultGroupQuota();
    }

    public Capacity getCapacity(String group, String tenant) {
        if (tenant != null) {
            return this.getTenantCapacity(tenant);
        }
        return this.getGroupCapacity(group);
    }

    public Capacity getCapacityWithDefault(String group, String tenant) {
        Integer maxAggrSize;
        Integer maxAggrCount;
        Integer maxSize;
        boolean isTenant = StringUtils.isNotBlank((CharSequence)tenant);
        Capacity capacity = isTenant ? this.getTenantCapacity(tenant) : this.getGroupCapacity(group);
        if (capacity == null) {
            return null;
        }
        Integer quota = capacity.getQuota();
        if (quota == 0) {
            if (isTenant) {
                capacity.setQuota(PropertyUtil.getDefaultTenantQuota());
            } else if ("".equals(group)) {
                capacity.setQuota(PropertyUtil.getDefaultClusterQuota());
            } else {
                capacity.setQuota(PropertyUtil.getDefaultGroupQuota());
            }
        }
        if ((maxSize = capacity.getMaxSize()) == 0) {
            capacity.setMaxSize(PropertyUtil.getDefaultMaxSize());
        }
        if ((maxAggrCount = capacity.getMaxAggrCount()) == 0) {
            capacity.setMaxAggrCount(PropertyUtil.getDefaultMaxAggrCount());
        }
        if ((maxAggrSize = capacity.getMaxAggrSize()) == 0) {
            capacity.setMaxAggrSize(PropertyUtil.getDefaultMaxAggrSize());
        }
        return capacity;
    }

    public boolean initCapacity(String group, String tenant) {
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            return this.initTenantCapacity(tenant);
        }
        if ("".equals(group)) {
            return this.insertGroupCapacity("");
        }
        return this.initGroupCapacity(group);
    }

    private boolean insertGroupCapacity(String group) {
        return this.insertGroupCapacity(group, null, null, null, null);
    }

    private boolean insertGroupCapacity(String group, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        try {
            Timestamp now = TimeUtils.getCurrentTime();
            GroupCapacity groupCapacity = new GroupCapacity();
            groupCapacity.setGroup(group);
            groupCapacity.setQuota(quota == null ? ZERO : quota);
            groupCapacity.setMaxSize(maxSize == null ? ZERO : maxSize);
            groupCapacity.setMaxAggrCount(maxAggrCount == null ? ZERO : maxAggrCount);
            groupCapacity.setMaxAggrSize(maxAggrSize == null ? ZERO : maxAggrSize);
            groupCapacity.setGmtCreate(now);
            groupCapacity.setGmtModified(now);
            return this.groupCapacityPersistService.insertGroupCapacity(groupCapacity);
        }
        catch (DuplicateKeyException e) {
            LogUtil.defaultLog.warn("group: {}, message: {}", (Object)group, (Object)e.getMessage());
            return false;
        }
    }

    private boolean updateGroupUsage(CounterMode counterMode, String group, int defaultQuota, boolean ignoreQuotaLimit) {
        Timestamp now = TimeUtils.getCurrentTime();
        GroupCapacity groupCapacity = new GroupCapacity();
        groupCapacity.setGroup(group);
        groupCapacity.setQuota(defaultQuota);
        groupCapacity.setGmtModified(now);
        if (CounterMode.INCREMENT == counterMode) {
            if (ignoreQuotaLimit) {
                return this.groupCapacityPersistService.incrementUsage(groupCapacity);
            }
            return this.groupCapacityPersistService.incrementUsageWithDefaultQuotaLimit(groupCapacity) || this.groupCapacityPersistService.incrementUsageWithQuotaLimit(groupCapacity);
        }
        return this.groupCapacityPersistService.decrementUsage(groupCapacity);
    }

    public boolean insertAndUpdateTenantUsage(CounterMode counterMode, String tenant, boolean ignoreQuotaLimit) {
        TenantCapacity tenantCapacity = this.getTenantCapacity(tenant);
        if (tenantCapacity == null) {
            this.initTenantCapacity(tenant);
        }
        return this.updateTenantUsage(counterMode, tenant, ignoreQuotaLimit);
    }

    private boolean updateTenantUsage(CounterMode counterMode, String tenant, boolean ignoreQuotaLimit) {
        Timestamp now = TimeUtils.getCurrentTime();
        TenantCapacity tenantCapacity = new TenantCapacity();
        tenantCapacity.setTenant(tenant);
        tenantCapacity.setQuota(PropertyUtil.getDefaultTenantQuota());
        tenantCapacity.setGmtModified(now);
        if (CounterMode.INCREMENT == counterMode) {
            if (ignoreQuotaLimit) {
                return this.tenantCapacityPersistService.incrementUsage(tenantCapacity);
            }
            return this.tenantCapacityPersistService.incrementUsageWithDefaultQuotaLimit(tenantCapacity) || this.tenantCapacityPersistService.incrementUsageWithQuotaLimit(tenantCapacity);
        }
        return this.tenantCapacityPersistService.decrementUsage(tenantCapacity);
    }

    public boolean updateTenantUsage(CounterMode counterMode, String tenant) {
        return this.updateTenantUsage(counterMode, tenant, false);
    }

    public boolean initTenantCapacity(String tenant) {
        return this.initTenantCapacity(tenant, null, null, null, null);
    }

    public boolean initTenantCapacity(String tenant, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        boolean insertSuccess = this.insertTenantCapacity(tenant, quota, maxSize, maxAggrCount, maxAggrSize);
        if (quota != null) {
            return insertSuccess;
        }
        this.autoExpansion(null, tenant);
        return insertSuccess;
    }

    private boolean insertTenantCapacity(String tenant) {
        return this.insertTenantCapacity(tenant, null, null, null, null);
    }

    private boolean insertTenantCapacity(String tenant, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        try {
            Timestamp now = TimeUtils.getCurrentTime();
            TenantCapacity tenantCapacity = new TenantCapacity();
            tenantCapacity.setTenant(tenant);
            tenantCapacity.setQuota(quota == null ? ZERO : quota);
            tenantCapacity.setMaxSize(maxSize == null ? ZERO : maxSize);
            tenantCapacity.setMaxAggrCount(maxAggrCount == null ? ZERO : maxAggrCount);
            tenantCapacity.setMaxAggrSize(maxAggrSize == null ? ZERO : maxAggrSize);
            tenantCapacity.setGmtCreate(now);
            tenantCapacity.setGmtModified(now);
            return this.tenantCapacityPersistService.insertTenantCapacity(tenantCapacity);
        }
        catch (DuplicateKeyException e) {
            LogUtil.defaultLog.warn("tenant: {}, message: {}", (Object)tenant, (Object)e.getMessage());
            return false;
        }
    }

    public TenantCapacity getTenantCapacity(String tenant) {
        return this.tenantCapacityPersistService.getTenantCapacity(tenant);
    }

    public boolean insertOrUpdateCapacity(String group, String tenant, Integer quota, Integer maxSize, Integer maxAggrCount, Integer maxAggrSize) {
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            TenantCapacity capacity = this.tenantCapacityPersistService.getTenantCapacity(tenant);
            if (capacity == null) {
                return this.initTenantCapacity(tenant, quota, maxSize, maxAggrCount, maxAggrSize);
            }
            return this.tenantCapacityPersistService.updateTenantCapacity(tenant, quota, maxSize, maxAggrCount, maxAggrSize);
        }
        GroupCapacity capacity = this.groupCapacityPersistService.getGroupCapacity(group);
        if (capacity == null) {
            return this.initGroupCapacity(group, quota, maxSize, maxAggrCount, maxAggrSize);
        }
        return this.groupCapacityPersistService.updateGroupCapacity(group, quota, maxSize, maxAggrCount, maxAggrSize);
    }
}

