/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.model.ACLInfo;
import com.alibaba.nacos.config.server.utils.JSONUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ClientIpWhiteList {
    public static final String CLIENT_IP_WHITELIST_METADATA = "com.alibaba.nacos.metadata.clientIpWhitelist";
    static final AtomicReference<List<String>> CLIENT_IP_WHITELIST = new AtomicReference(new ArrayList());
    static Boolean isOpen = false;

    public static boolean isLegalClient(String clientIp) {
        if (StringUtils.isBlank((CharSequence)clientIp)) {
            throw new IllegalArgumentException();
        }
        clientIp = clientIp.trim();
        return CLIENT_IP_WHITELIST.get().contains(clientIp);
    }

    public static boolean isEnableWhitelist() {
        return isOpen;
    }

    public static void load(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LogUtil.defaultLog.warn("clientIpWhiteList is blank.close whitelist.");
            isOpen = false;
            CLIENT_IP_WHITELIST.get().clear();
            return;
        }
        LogUtil.defaultLog.warn("[clientIpWhiteList] {}", (Object)content);
        try {
            ACLInfo acl = (ACLInfo)JSONUtils.deserializeObject(content, ACLInfo.class);
            isOpen = acl.getIsOpen();
            CLIENT_IP_WHITELIST.set(acl.getIps());
        }
        catch (Exception ioe) {
            LogUtil.defaultLog.error("failed to load clientIpWhiteList, " + ioe.toString(), (Throwable)ioe);
        }
    }
}

