/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.manager;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskManagerMBean;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import org.slf4j.Logger;

public final class TaskManager
implements TaskManagerMBean {
    private static final Logger log = LogUtil.defaultLog;
    private final ConcurrentHashMap<String, AbstractTask> tasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TaskProcessor> taskProcessors = new ConcurrentHashMap();
    private TaskProcessor defaultTaskProcessor;
    Thread processingThread;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private String name;
    ReentrantLock lock = new ReentrantLock();
    Condition notEmpty = this.lock.newCondition();

    public TaskManager() {
        this(null);
    }

    public AbstractTask getTask(String type) {
        return this.tasks.get(type);
    }

    public TaskProcessor getTaskProcessor(String type) {
        return this.taskProcessors.get(type);
    }

    public TaskManager(String name) {
        this.name = name;
        this.processingThread = null != name && name.length() > 0 ? new Thread((Runnable)new ProcessRunnable(), name) : new Thread(new ProcessRunnable());
        this.processingThread.setDaemon(true);
        this.closed.set(false);
        this.processingThread.start();
    }

    public int size() {
        return this.tasks.size();
    }

    public void close() {
        this.closed.set(true);
        this.processingThread.interrupt();
    }

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.isEmpty()) {
                this.notEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        boolean isawait = false;
        try {
            while (!this.isEmpty()) {
                isawait = this.notEmpty.await(timeout, unit);
            }
            boolean bl = isawait;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addProcessor(String type, TaskProcessor taskProcessor) {
        this.taskProcessors.put(type, taskProcessor);
    }

    public void removeProcessor(String type) {
        this.taskProcessors.remove(type);
    }

    public void removeTask(String type) {
        this.lock.lock();
        try {
            this.tasks.remove(type);
            MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String type, AbstractTask task) {
        this.lock.lock();
        try {
            AbstractTask oldTask = this.tasks.put(type, task);
            MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
            if (null != oldTask) {
                task.merge(oldTask);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        for (Map.Entry<String, AbstractTask> entry : this.tasks.entrySet()) {
            AbstractTask task;
            block12: {
                task = null;
                this.lock.lock();
                try {
                    task = entry.getValue();
                    if (null == task) break block12;
                    if (!task.shouldProcess()) continue;
                    this.tasks.remove(entry.getKey());
                    MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
            }
            if (null == task) continue;
            TaskProcessor processor = this.taskProcessors.get(entry.getKey());
            if (null == processor) {
                processor = this.getDefaultTaskProcessor();
            }
            if (null == processor) continue;
            boolean result = false;
            try {
                result = processor.process(entry.getKey(), task);
            }
            catch (Throwable t) {
                log.error("task_fail", (Object)"\u5904\u7406task\u5931\u8d25", (Object)t);
            }
            if (result) continue;
            task.setLastProcessTime(System.currentTimeMillis());
            this.addTask(entry.getKey(), task);
        }
        if (this.tasks.isEmpty()) {
            this.lock.lock();
            try {
                this.notEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public TaskProcessor getDefaultTaskProcessor() {
        this.lock.lock();
        try {
            TaskProcessor taskProcessor = this.defaultTaskProcessor;
            return taskProcessor;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDefaultTaskProcessor(TaskProcessor defaultTaskProcessor) {
        this.lock.lock();
        try {
            this.defaultTaskProcessor = defaultTaskProcessor;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getTaskInfos() {
        StringBuilder sb = new StringBuilder();
        for (String taskType : this.taskProcessors.keySet()) {
            sb.append(taskType).append(":");
            AbstractTask task = this.tasks.get(taskType);
            if (task != null) {
                sb.append(new Date(task.getLastProcessTime()).toString());
            } else {
                sb.append("finished");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public void init() {
        try {
            ObjectName oName = new ObjectName(this.name + ":type=" + TaskManager.class.getSimpleName());
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, oName);
        }
        catch (Exception e) {
            log.error("registerMBean_fail", (Object)"\u6ce8\u518cmbean\u51fa\u9519", (Object)e);
        }
    }

    class ProcessRunnable
    implements Runnable {
        ProcessRunnable() {
        }

        @Override
        public void run() {
            while (!TaskManager.this.closed.get()) {
                try {
                    Thread.sleep(100L);
                    TaskManager.this.process();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

