/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.security;

import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityProxy {
    private static final Logger SECURITY_LOGGER = LoggerFactory.getLogger(SecurityProxy.class);
    private static final String LOGIN_URL = "/v1/auth/users/login";
    private final NacosRestTemplate nacosRestTemplate;
    private final String contextPath;
    private final String username;
    private final String password;
    private volatile String accessToken;
    private long tokenTtl;
    private long lastRefreshTime;
    private long tokenRefreshWindow;

    public SecurityProxy(Properties properties, NacosRestTemplate nacosRestTemplate) {
        this.username = properties.getProperty("username", "");
        this.password = properties.getProperty("password", "");
        this.contextPath = ContextPathUtil.normalizeContextPath(properties.getProperty("contextPath", "/nacos"));
        this.nacosRestTemplate = nacosRestTemplate;
    }

    public boolean login(List<String> servers) {
        try {
            if (System.currentTimeMillis() - this.lastRefreshTime < TimeUnit.SECONDS.toMillis(this.tokenTtl - this.tokenRefreshWindow)) {
                return true;
            }
            for (String server : servers) {
                if (!this.login(server)) continue;
                this.lastRefreshTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean login(String server) {
        if (StringUtils.isNotBlank((String)this.username)) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            HashMap<String, String> bodyMap = new HashMap<String, String>(2);
            params.put("username", this.username);
            bodyMap.put("password", this.password);
            String url = "http://" + server + this.contextPath + LOGIN_URL;
            if (server.contains("http")) {
                url = server + this.contextPath + LOGIN_URL;
            }
            try {
                HttpRestResult restResult = this.nacosRestTemplate.postForm(url, Header.EMPTY, Query.newInstance().initParams(params), bodyMap, String.class);
                if (!restResult.ok()) {
                    SECURITY_LOGGER.error("login failed: {}", (Object)JacksonUtils.toJson((Object)restResult));
                    return false;
                }
                JsonNode obj = JacksonUtils.toObj((String)((String)restResult.getData()));
                if (obj.has("accessToken")) {
                    this.accessToken = obj.get("accessToken").asText();
                    this.tokenTtl = obj.get("tokenTtl").asInt();
                    this.tokenRefreshWindow = this.tokenTtl / 10L;
                }
            }
            catch (Exception e) {
                SECURITY_LOGGER.error("[SecurityProxy] login http request failed url: {}, params: {}, bodyMap: {}, errorMsg: {}", new Object[]{url, params, bodyMap, e.getMessage()});
                return false;
            }
        }
        return true;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isEnabled() {
        return StringUtils.isNotBlank((String)this.username);
    }
}

