/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.event.InstancesChangeNotifier;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServiceInfoUpdateService
implements Closeable {
    private static final long DEFAULT_DELAY = 1000L;
    private static final int DEFAULT_UPDATE_CACHE_TIME_MULTIPLE = 6;
    private final Map<String, ScheduledFuture<?>> futureMap = new HashMap();
    private final ServiceInfoHolder serviceInfoHolder;
    private final ScheduledExecutorService executor;
    private final NamingClientProxy namingClientProxy;
    private final InstancesChangeNotifier changeNotifier;

    public ServiceInfoUpdateService(Properties properties, ServiceInfoHolder serviceInfoHolder, NamingClientProxy namingClientProxy, InstancesChangeNotifier changeNotifier) {
        this.executor = new ScheduledThreadPoolExecutor(this.initPollingThreadCount(properties), (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.naming.updater"));
        this.serviceInfoHolder = serviceInfoHolder;
        this.namingClientProxy = namingClientProxy;
        this.changeNotifier = changeNotifier;
    }

    private int initPollingThreadCount(Properties properties) {
        if (properties == null) {
            return UtilAndComs.DEFAULT_POLLING_THREAD_COUNT;
        }
        return ConvertUtils.toInt((String)properties.getProperty("namingPollingThreadCount"), (int)UtilAndComs.DEFAULT_POLLING_THREAD_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdateIfAbsent(String serviceName, String groupName, String clusters) {
        String serviceKey = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)clusters);
        if (this.futureMap.get(serviceKey) != null) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = this.futureMap;
        synchronized (map) {
            if (this.futureMap.get(serviceKey) != null) {
                return;
            }
            ScheduledFuture<?> future = this.addTask(new UpdateTask(serviceName, groupName, clusters));
            this.futureMap.put(serviceKey, future);
        }
    }

    private synchronized ScheduledFuture<?> addTask(UpdateTask task) {
        return this.executor.schedule(task, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUpdateIfContain(String serviceName, String groupName, String clusters) {
        String serviceKey = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)clusters);
        if (!this.futureMap.containsKey(serviceKey)) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = this.futureMap;
        synchronized (map) {
            if (!this.futureMap.containsKey(serviceKey)) {
                return;
            }
            this.futureMap.remove(serviceKey);
        }
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executor, (Logger)LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public class UpdateTask
    implements Runnable {
        long lastRefTime = Long.MAX_VALUE;
        private final String serviceName;
        private final String groupName;
        private final String clusters;
        private final String groupedServiceName;
        private final String serviceKey;
        private int failCount = 0;

        public UpdateTask(String serviceName, String groupName, String clusters) {
            this.serviceName = serviceName;
            this.groupName = groupName;
            this.clusters = clusters;
            this.groupedServiceName = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
            this.serviceKey = ServiceInfo.getKey((String)this.groupedServiceName, (String)clusters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delayTime = 1000L;
            try {
                if (!ServiceInfoUpdateService.this.changeNotifier.isSubscribed(this.groupName, this.serviceName, this.clusters) && !ServiceInfoUpdateService.this.futureMap.containsKey(this.serviceKey)) {
                    LogUtils.NAMING_LOGGER.info("update task is stopped, service:" + this.groupedServiceName + ", clusters:" + this.clusters);
                    return;
                }
                ServiceInfo serviceObj = ServiceInfoUpdateService.this.serviceInfoHolder.getServiceInfoMap().get(this.serviceKey);
                if (serviceObj == null) {
                    serviceObj = ServiceInfoUpdateService.this.namingClientProxy.queryInstancesOfService(this.serviceName, this.groupName, this.clusters, 0, false);
                    ServiceInfoUpdateService.this.serviceInfoHolder.processServiceInfo(serviceObj);
                    this.lastRefTime = serviceObj.getLastRefTime();
                    return;
                }
                if (serviceObj.getLastRefTime() <= this.lastRefTime) {
                    serviceObj = ServiceInfoUpdateService.this.namingClientProxy.queryInstancesOfService(this.serviceName, this.groupName, this.clusters, 0, false);
                    ServiceInfoUpdateService.this.serviceInfoHolder.processServiceInfo(serviceObj);
                }
                this.lastRefTime = serviceObj.getLastRefTime();
                if (CollectionUtils.isEmpty(serviceObj.getHosts())) {
                    this.incFailCount();
                    return;
                }
                delayTime = serviceObj.getCacheMillis() * 6L;
                this.resetFailCount();
            }
            catch (Throwable e) {
                this.incFailCount();
                LogUtils.NAMING_LOGGER.warn("[NA] failed to update serviceName: " + this.groupedServiceName, e);
            }
            finally {
                ServiceInfoUpdateService.this.executor.schedule(this, Math.min(delayTime << this.failCount, 60000L), TimeUnit.MILLISECONDS);
            }
        }

        private void incFailCount() {
            int limit = 6;
            if (this.failCount == limit) {
                return;
            }
            ++this.failCount;
        }

        private void resetFailCount() {
            this.failCount = 0;
        }
    }
}

