/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xslt.XSLDocumentBuilder;
import org.xml.sax.SAXException;

public class JXTransformerHandler
extends XSLDocumentBuilder
implements TransformerHandler,
XMLConstants {
    Result m_result;
    String m_systemId;
    JXTransformer m_transformer;
    boolean m_isDocument = false;
    String compVersion = null;

    public JXTransformerHandler(Transformer transformer) {
        this.m_transformer = (JXTransformer)transformer;
        this.setIsTransformer(true);
        this.m_transformer.setCompVersion(this.compVersion);
    }

    public JXTransformerHandler() {
        this.m_transformer = new JXTransformer();
        this.setIsTransformer(true);
        this.m_transformer.setCompVersion(this.compVersion);
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        this.m_result = result;
    }

    @Override
    public void setSystemId(String string) {
        this.m_systemId = string;
    }

    @Override
    public String getSystemId() {
        return this.m_systemId;
    }

    @Override
    public Transformer getTransformer() {
        return this.m_transformer;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.m_isDocument = true;
    }

    @Override
    public void endDocument() throws SAXException {
        XMLElement xMLElement = null;
        super.endDocument();
        xMLElement = this.m_isDocument ? this.getDocument() : this.getResultFragment();
        DOMSource dOMSource = new DOMSource(xMLElement, this.m_systemId);
        try {
            this.m_transformer.transform(dOMSource, this.m_result);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

