/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.util.Utils;

public final class OraclePKIX509CertHelper {
    private static final String a = "-----BEGIN CERTIFICATE-----";
    private static final String b = "-----END CERTIFICATE-----";

    public static final Vector readB64X509CertsFrom(Reader reader) throws IOException {
        boolean bl;
        boolean bl2;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Vector<String> vector = new Vector<String>();
        do {
            bl2 = false;
            bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.startsWith(a)) {
                    bl2 = true;
                    stringBuffer.append(string.substring(a.length()));
                    break;
                }
                string = bufferedReader.readLine();
            }
            if (!bl2) break;
            string = bufferedReader.readLine();
            while (string != null) {
                if (string.indexOf(b) != -1) {
                    bl = true;
                    stringBuffer.append(string.substring(0, string.indexOf(b)));
                    break;
                }
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            if (!bl) break;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != ' ') continue;
                stringBuffer.deleteCharAt(i);
            }
            string = new X509((InputStream)new ByteArrayInputStream(Utils.fromBase64((String)stringBuffer.toString())));
            vector.addElement(string);
        } while (bl2 && bl);
        if (!(bl2 && bl || vector.size() != 0)) {
            throw new IOException();
        }
        return vector;
    }

    public static final X509 readB64X509CertFrom(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.startsWith(a)) {
                bl = true;
                stringBuffer.append(string.substring(a.length()));
                break;
            }
            string = bufferedReader.readLine();
        }
        if (!bl) {
            throw new IOException();
        }
        string = bufferedReader.readLine();
        while (string != null) {
            if (string.indexOf(b) != -1) {
                bl2 = true;
                stringBuffer.append(string.substring(0, string.indexOf(b)));
                break;
            }
            stringBuffer.append(string);
            string = bufferedReader.readLine();
        }
        if (!bl2) {
            throw new IOException();
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.deleteCharAt(i);
        }
        return new X509((InputStream)new ByteArrayInputStream(Utils.fromBase64((String)stringBuffer.toString())));
    }

    public static final Vector readB64X509PKCS7From(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        Object object = bufferedReader.readLine();
        while (object != null) {
            if (((String)object).startsWith(a)) {
                bl = true;
                stringBuffer.append(((String)object).substring(a.length()));
                break;
            }
            object = bufferedReader.readLine();
        }
        if (!bl) {
            throw new IOException();
        }
        object = bufferedReader.readLine();
        while (object != null) {
            if (((String)object).startsWith(b)) {
                bl2 = true;
                break;
            }
            stringBuffer.append((String)object + "\n");
            object = bufferedReader.readLine();
        }
        if (!bl2) {
            throw new IOException();
        }
        object = new PKCS7((InputStream)new ByteArrayInputStream(Utils.fromBase64((String)stringBuffer.toString()))).getCertificates();
        return object;
    }

    public static final void writeB64X509CertTo(Writer writer, X509 x509) throws IOException {
        String string = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])x509.getEncoded()) + b;
        writer.write(string);
        writer.close();
    }

    public static final void writeB64X509CertTo(Writer writer, byte[] byArray) throws IOException {
        String string = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + b;
        writer.write(string);
        writer.close();
    }

    public static final String addCertHeaderFooter(String string) throws IOException {
        String string2 = null;
        string2 = "-----BEGIN CERTIFICATE-----\n" + string + "\n" + b;
        return string2;
    }

    public static final String removeCertHeaderFooter(String string) throws IOException {
        String string2 = null;
        if (!string.startsWith(a) || !string.endsWith(b)) {
            throw new IOException("No header or footer in B64 cert");
        }
        string2 = string.substring(a.length(), string.length() - b.length());
        return string2;
    }
}

