/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.convert;

import com.onlyoffice.client.DocumentServerClient;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.convertservice.convertrequest.Thumbnail;
import com.onlyoffice.service.convert.ConvertService;
import java.util.Arrays;
import lombok.Generated;

public class DefaultConvertServiceV2
implements ConvertService {
    private DocumentManager documentManager;
    private UrlManager urlManager;
    private DocumentServerClient documentServerClient;

    @Override
    public ConvertResponse processConvert(ConvertRequest convertRequest, String fileId) {
        String fileName = this.documentManager.getDocumentName(fileId);
        if (convertRequest.getFiletype() == null || convertRequest.getFiletype().isEmpty()) {
            convertRequest.setFiletype(this.documentManager.getExtension(fileName));
        }
        if (convertRequest.getKey() == null || convertRequest.getKey().isEmpty()) {
            convertRequest.setKey(this.documentManager.getDocumentKey(fileId, false));
        }
        if (convertRequest.getOutputtype() == null || convertRequest.getOutputtype().isEmpty()) {
            convertRequest.setOutputtype(this.documentManager.getDefaultConvertExtension(fileName));
        }
        if (convertRequest.getTitle() == null || convertRequest.getTitle().isEmpty()) {
            convertRequest.setTitle(this.documentManager.getBaseName(fileName) + "." + convertRequest.getOutputtype());
        }
        if (convertRequest.getUrl() == null || convertRequest.getUrl().isEmpty()) {
            convertRequest.setUrl(this.urlManager.getFileUrl(fileId));
        }
        if (Arrays.asList("bmp", "gif", "jpg", "png").contains(convertRequest.getOutputtype()) && convertRequest.getThumbnail() == null) {
            Thumbnail thumbnail = Thumbnail.builder().first(false).build();
            convertRequest.setThumbnail(thumbnail);
        }
        return this.documentServerClient.convert(convertRequest);
    }

    @Generated
    public DefaultConvertServiceV2(DocumentManager documentManager, UrlManager urlManager, DocumentServerClient documentServerClient) {
        this.documentManager = documentManager;
        this.urlManager = urlManager;
        this.documentServerClient = documentServerClient;
    }

    @Generated
    protected DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    @Generated
    protected void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    @Generated
    protected UrlManager getUrlManager() {
        return this.urlManager;
    }

    @Generated
    protected void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    @Generated
    protected DocumentServerClient getDocumentServerClient() {
        return this.documentServerClient;
    }

    @Generated
    protected void setDocumentServerClient(DocumentServerClient documentServerClient) {
        this.documentServerClient = documentServerClient;
    }
}

