/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol.flt;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import java.io.IOException;

public class OceanBaseSerialize {
    public static long OB_MAX_V1B = 64L;
    public static long OB_MAX_V2B = 8192L;
    public static long OB_MAX_V3B = 0x100000L;
    public static long OB_MAX_V4B = 0x8000000L;
    public static long OB_MAX_V5B = 4L;
    public static long OB_MAX_V6B = 512L;
    public static long OB_MAX_V7B = 65536L;
    public static long OB_MAX_V8B = 0x800000L;
    public static long OB_MAX_V9B = 0x40000000L;

    public static long encoded_length_vi64(long val) {
        long need_bytes = val <= OB_MAX_V1B ? 1L : (val <= OB_MAX_V2B ? 2L : (val <= OB_MAX_V3B ? 3L : (val <= OB_MAX_V4B ? 4L : (val <= OB_MAX_V5B ? 5L : (val <= OB_MAX_V6B ? 6L : (val <= OB_MAX_V7B ? 7L : (val <= OB_MAX_V8B ? 8L : (val <= OB_MAX_V9B ? 9L : 10L))))))));
        return need_bytes;
    }

    public static long encoded_length_vstr_with_len(long len) {
        return OceanBaseSerialize.encoded_length_vi64(len) + len + 1L;
    }

    public static void encode_vstr_with_len(Buffer buf, byte[] vbuf, long vlen) throws IOException {
        buf.checkRemainder(OceanBaseSerialize.encoded_length_vstr_with_len(vlen));
        OceanBaseSerialize.encode_vi64(buf, vlen);
        if (vlen > 0L && null != vbuf) {
            buf.writeBytes(vbuf, 0, (int)vlen);
        }
        buf.writeByte((byte)0);
    }

    public static void encode_int8_t(Buffer buf, byte val) throws IOException {
        OceanBaseSerialize.encode_i8(buf, val);
    }

    public static void encode_i8(Buffer buf, byte val) throws IOException {
        buf.checkRemainder(1L);
        buf.writeByte(val);
    }

    public static void encode_vi64(Buffer buf, long val) throws IOException {
        long __v;
        buf.checkRemainder(OceanBaseSerialize.encoded_length_vi64(__v));
        for (__v = val; __v > OB_MAX_V1B; __v >>= 7) {
            buf.writeByte((byte)(__v | 0x80L));
        }
        if (__v <= OB_MAX_V1B) {
            buf.writeByte((byte)(__v & 0x7FL));
        }
    }

    public static byte decode_int8_t(Buffer buf) throws IOException {
        return OceanBaseSerialize.decode_i8(buf);
    }

    public static byte decode_i8(Buffer buf) throws IOException {
        buf.checkRemainder(1L);
        return buf.readByte();
    }

    public static long decode_vi64(Buffer buf) throws IOException {
        long __v = 0L;
        int shift = 0;
        while ((buf.getByte() & 0x80) != 0) {
            buf.checkRemainder(1L);
            __v |= ((long)buf.readByte() & 0x7FL) << shift;
            shift += 7;
        }
        buf.checkRemainder(1L);
        long val = __v |= ((long)buf.readByte() & 0x7FL) << shift;
        return val;
    }

    public static byte[] decode_vstr_nocopy(Buffer buf) throws IOException {
        byte[] str = null;
        long lenp = OceanBaseSerialize.decode_vi64(buf);
        if (lenp >= 0L) {
            buf.checkRemainder(lenp);
            str = buf.readBytes((int)lenp);
            buf.skipByte();
        }
        return str;
    }
}

