/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class OBNStringParameter
implements Cloneable,
ParameterHolder {
    private final String stringValue;
    private final boolean noBackslashEscapes;
    private final Charset charset;
    private final Charset nCharset;

    public OBNStringParameter(String str, boolean noBackslashEscapes, String characterEncoding, String nCharacterEncoding) {
        this.stringValue = str;
        this.noBackslashEscapes = noBackslashEscapes;
        this.charset = Charset.forName(characterEncoding);
        this.nCharset = nCharacterEncoding != null && !nCharacterEncoding.isEmpty() ? Charset.forName(nCharacterEncoding) : null;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        if (this.nCharset == null) {
            pos.write(110);
            pos.write(39);
            pos.writeBytesEscapedQuote(this.stringValue.getBytes(this.charset), this.stringValue.getBytes(this.charset).length, this.noBackslashEscapes);
        } else {
            pos.write("u");
            pos.write(39);
            StringBuilder unicodeBuilder = new StringBuilder("");
            for (char c : this.stringValue.toCharArray()) {
                unicodeBuilder.append(String.format("\\%04x", c));
            }
            String unicodeStr = unicodeBuilder.toString();
            pos.writeBytesEscapedQuote(unicodeStr.getBytes(this.charset), unicodeStr.getBytes(this.charset).length, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.stringValue.length() * 3;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        byte[] bytes = this.nCharset == null ? this.stringValue.getBytes(this.charset) : this.stringValue.getBytes(this.nCharset);
        pos.writeFieldLength(bytes.length);
        pos.write(bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.NCHAR;
    }

    @Override
    public String toString() {
        if (this.stringValue.length() < 1024) {
            return "'" + this.stringValue + "'";
        }
        return "'" + this.stringValue.substring(0, 1024) + "...'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

