/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.shared;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.recipes.shared.SharedCountListener;
import com.netflix.curator.framework.recipes.shared.SharedCountReader;
import com.netflix.curator.framework.recipes.shared.SharedValue;
import com.netflix.curator.framework.recipes.shared.SharedValueListener;
import com.netflix.curator.framework.recipes.shared.SharedValueReader;
import com.netflix.curator.framework.state.ConnectionState;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;

public class SharedCount
implements Closeable,
SharedCountReader,
Listenable<SharedCountListener> {
    private final Map<SharedCountListener, SharedValueListener> listeners = Maps.newConcurrentMap();
    private final SharedValue sharedValue;

    public SharedCount(CuratorFramework client, String path, int seedValue) {
        this.sharedValue = new SharedValue(client, path, SharedCount.toBytes(seedValue));
    }

    @Override
    public int getCount() {
        return SharedCount.fromBytes(this.sharedValue.getValue());
    }

    public void setCount(int newCount) throws Exception {
        this.sharedValue.setValue(SharedCount.toBytes(newCount));
    }

    public boolean trySetCount(int newCount) throws Exception {
        return this.sharedValue.trySetValue(SharedCount.toBytes(newCount));
    }

    public void addListener(SharedCountListener listener) {
        this.addListener(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public void addListener(final SharedCountListener listener, Executor executor) {
        SharedValueListener valueListener = new SharedValueListener(){

            @Override
            public void valueHasChanged(SharedValueReader sharedValue, byte[] newValue) throws Exception {
                listener.countHasChanged(SharedCount.this, SharedCount.fromBytes(newValue));
            }

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                listener.stateChanged(client, newState);
            }
        };
        this.sharedValue.getListenable().addListener((Object)valueListener, executor);
        this.listeners.put(listener, valueListener);
    }

    public void removeListener(SharedCountListener listener) {
        this.listeners.remove(listener);
    }

    public void start() throws Exception {
        this.sharedValue.start();
    }

    @Override
    public void close() throws IOException {
        this.sharedValue.close();
    }

    private static byte[] toBytes(int value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putInt(value);
        return bytes;
    }

    private static int fromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }
}

