/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.registercenter.nacos.decorator;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.listener.register.RegisterListenerExecutor;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosServiceRegistryDecorator
extends NacosServiceRegistry {
    private NacosServiceRegistry serviceRegistry;
    private ConfigurableApplicationContext applicationContext;
    private ConfigurableEnvironment environment;

    public NacosServiceRegistryDecorator(NacosDiscoveryProperties nacosDiscoveryProperties, NacosServiceRegistry serviceRegistry, ConfigurableApplicationContext applicationContext) {
        super(nacosDiscoveryProperties);
        this.serviceRegistry = serviceRegistry;
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    public void register(Registration registration) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onRegister(registration);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.register(registration);
    }

    public void deregister(Registration registration) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onDeregister(registration);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.deregister(registration);
    }

    public void setStatus(Registration registration, String status) {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onSetStatus(registration, status);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.setStatus(registration, status);
    }

    public Object getStatus(Registration registration) {
        return this.serviceRegistry.getStatus(registration);
    }

    public void close() {
        Boolean registerControlEnabled = PluginContextAware.isRegisterControlEnabled((Environment)this.environment);
        if (registerControlEnabled.booleanValue()) {
            try {
                RegisterListenerExecutor registerListenerExecutor = (RegisterListenerExecutor)this.applicationContext.getBean(RegisterListenerExecutor.class);
                registerListenerExecutor.onClose();
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        this.serviceRegistry.close();
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }
}

