/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.util.ResponseUtil;
import com.nepxion.discovery.plugin.admincenter.resource.VersionResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/version"})
@Api(tags={"\u7248\u672c\u63a5\u53e3"})
public class VersionEndpoint {
    @Autowired
    private VersionResource versionResource;

    @RequestMapping(path={"/update-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u66f4\u65b0\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateAsync(@RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a${dynamicVersion}\u6216\u8005${dynamicVersion};${localVersion}", required=true) String version) {
        return this.doUpdate(version, true);
    }

    @RequestMapping(path={"/update-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u66f4\u65b0\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateSync(@RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a${dynamicVersion}\u6216\u8005${dynamicVersion};${localVersion}", required=true) String version) {
        return this.doUpdate(version, false);
    }

    @RequestMapping(path={"/clear-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u6e05\u9664\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearAsync(@RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.doClear(version, true);
    }

    @RequestMapping(path={"/clear-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u6e05\u9664\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearSync(@RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.doClear(version, false);
    }

    @RequestMapping(path={"/view"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u672c\u5730\u7248\u672c\u548c\u52a8\u6001\u7248\u672c", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> view() {
        return this.doView();
    }

    private ResponseEntity<?> doUpdate(String version, boolean async) {
        try {
            this.versionResource.update(version, async);
            return ResponseUtil.getSuccessResponse((Object)true);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doClear(String version, boolean async) {
        try {
            this.versionResource.clear(version, async);
            return ResponseUtil.getSuccessResponse((Object)true);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doView() {
        try {
            List<String> versionList = this.versionResource.view();
            return ResponseUtil.getSuccessResponse(versionList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }
}

