/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io.resource;

import com.mzlion.core.io.resource.ClassPathResourceDescriptor;
import com.mzlion.core.io.resource.FileSystemResourceDescriptor;
import com.mzlion.core.io.resource.ResourceDescriptor;
import com.mzlion.core.io.resource.ResourceDescriptorLoader;
import com.mzlion.core.io.resource.URLResourceDescriptor;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.utils.ClassLoaderUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultResourceDescriptorLoader
implements ResourceDescriptorLoader {
    private ClassLoader classLoader;

    public DefaultResourceDescriptorLoader() {
        this(ClassLoaderUtils.getDefaultClassLoader());
    }

    public DefaultResourceDescriptorLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ResourceDescriptor getResourceDescriptor(String location) {
        Assert.hasLength(location, "Location must not be null");
        if (location.startsWith("classpath:")) {
            return new ClassPathResourceDescriptor(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(location);
            return new URLResourceDescriptor(url);
        }
        catch (MalformedURLException ex) {
            return new FileSystemResourceDescriptor(location);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : ClassLoaderUtils.getDefaultClassLoader();
    }
}

