/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.date;

import java.util.Calendar;
import java.util.Date;

public class DateCalcUtils {
    private DateCalcUtils() {
        throw new UnsupportedOperationException();
    }

    public static Date addMilliSecond(Date date, int milliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(14, milliSecond);
        return calendar.getTime();
    }

    public static Date addSecond(Date date, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, minutes);
        return cal.getTime();
    }

    public static Date addHour(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date addDate(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int months) {
        return DateCalcUtils.addMonth(date, months, false);
    }

    public static Date addMonth(Date date, int months, boolean escapeDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (escapeDays) {
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date addYear(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int get24Hour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int get12Hour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(10);
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int getMillisecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        System.currentTimeMillis();
        return calendar.get(14);
    }

    public static long getTimeMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static boolean isLeapYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        boolean leap = false;
        if (year % 400 == 0) {
            leap = true;
        } else if (year % 100 == 0) {
            leap = false;
        } else if (year % 4 == 0) {
            leap = true;
        }
        return leap;
    }

    public static Date getBeginDayInMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getEndDayInMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getDaysBetween(Date start, Date end) {
        Calendar srcCalendar = Calendar.getInstance();
        srcCalendar.setTime(start);
        srcCalendar.set(11, 0);
        srcCalendar.set(12, 0);
        srcCalendar.set(13, 0);
        Calendar destCalendar = Calendar.getInstance();
        destCalendar.setTime(end);
        destCalendar.set(11, 0);
        destCalendar.set(12, 0);
        destCalendar.set(13, 0);
        if (srcCalendar.after(destCalendar)) {
            Calendar tempCalendar = srcCalendar;
            srcCalendar = destCalendar;
            destCalendar = tempCalendar;
        }
        return (int)((destCalendar.getTimeInMillis() - srcCalendar.getTimeInMillis()) / 86400000L);
    }

    public static int getMonthsBetween(Date start, Date end) {
        Calendar srcCalendar = Calendar.getInstance();
        srcCalendar.setTime(start);
        Calendar destCalendar = Calendar.getInstance();
        destCalendar.setTime(end);
        if (srcCalendar.after(destCalendar)) {
            Calendar tempCalendar = srcCalendar;
            srcCalendar = destCalendar;
            destCalendar = tempCalendar;
        }
        int months = destCalendar.get(2) - srcCalendar.get(2);
        int destYear = destCalendar.get(1);
        if (srcCalendar.get(1) != destYear) {
            srcCalendar = (Calendar)srcCalendar.clone();
            do {
                months += srcCalendar.getActualMaximum(2) + 1;
                srcCalendar.add(1, 1);
            } while (srcCalendar.get(1) != destYear);
            return months;
        }
        return months;
    }

    public static int dateDiff(int datePart, Date startDate, Date endDate) {
        return -1;
    }
}

