/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.maven.apt;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public class FileSync {
    public static void syncFiles(File source, File target) throws IOException {
        HashSet sourceFiles = Sets.newHashSet((Object[])source.list());
        HashSet targetFiles = Sets.newHashSet((Object[])target.list());
        for (String targetFile : targetFiles) {
            if (sourceFiles.contains(targetFile)) continue;
            FileSync.deleteFile(new File(target, targetFile));
        }
        for (String sourceFile : sourceFiles) {
            File file = new File(source, sourceFile);
            File file2 = new File(target, sourceFile);
            if (file.isFile()) {
                FileSync.copyIfChanged(file, file2);
                continue;
            }
            file2.mkdir();
            FileSync.syncFiles(file, file2);
        }
    }

    private static void copyIfChanged(File source, File target) throws IOException {
        if (target.exists()) {
            if (source.length() == target.length() && FileUtils.checksumCRC32((File)source) == FileUtils.checksumCRC32((File)target)) {
                return;
            }
            target.delete();
        }
        if (!source.renameTo(target)) {
            Files.move((File)source, (File)target);
        }
    }

    private static void deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
        } else {
            file.delete();
        }
    }

    private FileSync() {
    }
}

