/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.processor.MyBatisFlexProps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.ibatis.type.UnknownTypeHandler;

public class QueryEntityProcessor
extends AbstractProcessor {
    private static final List<String> defaultSupportColumnTypes = Arrays.asList(Integer.TYPE.getName(), Integer.class.getName(), Short.TYPE.getName(), Short.class.getName(), Long.TYPE.getName(), Long.class.getName(), Float.TYPE.getName(), Float.class.getName(), Double.TYPE.getName(), Double.class.getName(), Boolean.TYPE.getName(), Boolean.class.getName(), java.util.Date.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), Year.class.getName(), Month.class.getName(), YearMonth.class.getName(), JapaneseDate.class.getName(), byte[].class.getName(), Byte[].class.getName(), Byte.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), Character.TYPE.getName(), String.class.getName(), Character.class.getName());
    private static final String mapperTemplate = "package @package;\n\nimport @baseMapperClass;\nimport @entityClass;\n\npublic interface @entityNameMapper extends @baseMapperClzName<@entityName> {\n}\n";
    private static final String classTableTemplate = "package @package;\n\nimport com.mybatisflex.core.query.QueryColumn;\nimport com.mybatisflex.core.table.TableDef;\n\n// Auto generate by mybatis-flex, do not modify it.\npublic class @tablesClassName {\n@classesInfo}\n";
    private static final String tableDefTemplate = "\n\n    public static final @entityClassTableDef @tableField = new @entityClassTableDef(\"@schema\", \"@tableName\");\n";
    private static final String singleEntityClassTemplate = "package @package;\n\nimport com.mybatisflex.core.query.QueryColumn;\nimport com.mybatisflex.core.table.TableDef;\n\n// Auto generate by mybatis-flex, do not modify it.\npublic class @entityClassTableDef extends TableDef {\n\n@selfDef@queryColumns@defaultColumns@allColumns\n    public @entityClassTableDef(String schema, String tableName) {\n        super(schema, tableName);\n    }\n}\n";
    private static final String allInTableEntityClassTemplate = "\n    public static class @entityClassTableDef extends TableDef {\n\n@queryColumns@defaultColumns@allColumns\n        public @entityClassTableDef(String schema, String tableName) {\n            super(schema, tableName);\n        }\n    }\n";
    private static final String columnsTemplate = "        public QueryColumn @property = new QueryColumn(this, \"@columnName\");\n";
    private static final String defaultColumnsTemplate = "\n        public QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{@allColumns};\n";
    private static final String allColumnsTemplate = "        public QueryColumn ALL_COLUMNS = new QueryColumn(this, \"*\");\n";
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            System.out.println("mybatis flex processor run start...");
            MyBatisFlexProps props = new MyBatisFlexProps(this.filer);
            String enable = props.getProperties().getProperty("processor.enable", "");
            if ("false".equalsIgnoreCase(enable)) {
                return true;
            }
            String genPath = props.getProperties().getProperty("processor.genPath", "");
            String genTablesPackage = props.getProperties().getProperty("processor.tablesPackage");
            String baseMapperClass = props.getProperties().getProperty("processor.baseMapperClass", "com.mybatisflex.core.BaseMapper");
            String mappersGenerateEnable = props.getProperties().getProperty("processor.mappersGenerateEnable", "false");
            String genMappersPackage = props.getProperties().getProperty("processor.mappersPackage");
            boolean allInTables = "true".equalsIgnoreCase(props.getProperties().getProperty("processor.allInTables", "false"));
            String className = props.getProperties().getProperty("processor.tablesClassName", "Tables");
            String tablesNameStyle = props.getProperties().getProperty("processor.tablesNameStyle", "upperCase");
            String tablesDefSuffix = props.getProperties().getProperty("processor.tablesDefSuffix", "");
            String[] entityIgnoreSuffixes = props.getProperties().getProperty("processor.entity.ignoreSuffixes", "").split(",");
            AtomicReference entityClassName = new AtomicReference();
            StringBuilder tablesContent = new StringBuilder();
            roundEnv.getElementsAnnotatedWith(Table.class).forEach(entityClassElement -> {
                Table table = entityClassElement.getAnnotation(Table.class);
                entityClassName.set(entityClassElement.toString());
                String schema = table != null && table.value().trim().length() != 0 ? table.schema() : "";
                String tableName = table != null && table.value().trim().length() != 0 ? table.value() : QueryEntityProcessor.firstCharToLowerCase(entityClassElement.getSimpleName().toString());
                LinkedHashMap<String, String> propertyAndColumns = new LinkedHashMap<String, String>();
                ArrayList<String> defaultColumns = new ArrayList<String>();
                TypeElement classElement = (TypeElement)entityClassElement;
                do {
                    this.fillPropertyAndColumns(propertyAndColumns, defaultColumns, classElement, table == null || table.camelToUnderline());
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String entitySimpleName = entityClassElement.getSimpleName().toString();
                if (entityIgnoreSuffixes.length > 0) {
                    for (String entityIgnoreSuffix : entityIgnoreSuffixes) {
                        if (!entitySimpleName.endsWith(entityIgnoreSuffix.trim())) continue;
                        entitySimpleName = entitySimpleName.substring(0, entitySimpleName.length() - entityIgnoreSuffix.length());
                        break;
                    }
                }
                if (allInTables) {
                    String content = this.buildTablesClass(entitySimpleName, schema, tableName, propertyAndColumns, defaultColumns, tablesNameStyle, tablesDefSuffix, null, allInTables);
                    tablesContent.append(content);
                } else {
                    String realGenPackage = QueryEntityProcessor.isEmpty(genMappersPackage) ? this.guessTablesPackage((String)entityClassName.get()) : genTablesPackage;
                    String content = this.buildTablesClass(entitySimpleName, schema, tableName, propertyAndColumns, defaultColumns, tablesNameStyle, tablesDefSuffix, realGenPackage, allInTables);
                    this.genClass(genPath, realGenPackage, entitySimpleName + "TableDef", content);
                }
                if ("true".equalsIgnoreCase(mappersGenerateEnable) && table.mapperGenerateEnable()) {
                    String realMapperPackage = QueryEntityProcessor.isEmpty(genMappersPackage) ? QueryEntityProcessor.guessMapperPackage(entityClassElement.toString()) : genMappersPackage;
                    this.genMapperClass(genPath, realMapperPackage, entityClassElement.toString(), baseMapperClass, entitySimpleName);
                }
            });
            if (allInTables && tablesContent.length() > 0) {
                String realGenPackage = QueryEntityProcessor.isEmpty(genTablesPackage) ? this.guessTablesPackage((String)entityClassName.get()) : genTablesPackage;
                this.genTablesClass(genPath, realGenPackage, className, tablesContent.toString());
            }
        }
        return false;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String guessTablesPackage(String entityClassName) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClassName.contains(".")) {
            guessPackage.append("table");
        } else {
            guessPackage.append(entityClassName, 0, entityClassName.lastIndexOf(".")).append(".table");
        }
        return guessPackage.toString();
    }

    private void fillPropertyAndColumns(Map<String, String> propertyAndColumns, List<String> defaultColumns, TypeElement classElement, boolean camelToUnderline) {
        for (Element element : classElement.getEnclosedElements()) {
            Column column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC) || (column = element.getAnnotation(Column.class)) != null && column.ignore()) continue;
            String[] typeHandlerClass = new String[]{""};
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                annotationMirror.getElementValues().forEach((executableElement, annotationValue) -> {
                    if (executableElement.getSimpleName().equals("typeHandler")) {
                        typeHandlerClass[0] = annotationValue.toString();
                    }
                });
            }
            TypeMirror typeMirror = element.asType();
            Element element2 = this.typeUtils.asElement(typeMirror);
            if (element2 != null) {
                typeMirror = element2.asType();
            }
            String typeString = typeMirror.toString().trim();
            TypeElement typeElement = null;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            }
            if ((column == null || typeHandlerClass[0].equals(UnknownTypeHandler.class.getName())) && !defaultSupportColumnTypes.contains(typeString) && typeElement != null && ElementKind.ENUM != typeElement.getKind()) continue;
            String columnName = column != null && column.value().trim().length() > 0 ? column.value() : (camelToUnderline ? QueryEntityProcessor.camelToUnderline(element.toString()) : element.toString());
            propertyAndColumns.put(element.toString(), columnName);
            if (column != null && (column.isLarge() || column.isLogicDelete())) continue;
            defaultColumns.add(columnName);
        }
    }

    private static String guessMapperPackage(String entityClassName) {
        if (!entityClassName.contains(".")) {
            return "mapper";
        }
        String entityPackage = entityClassName.substring(0, entityClassName.lastIndexOf("."));
        if (entityPackage.contains(".")) {
            return entityPackage.substring(0, entityPackage.lastIndexOf(".")) + ".mapper";
        }
        return "mapper";
    }

    private static String buildName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return QueryEntityProcessor.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(style)) {
            return QueryEntityProcessor.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(style)) {
            return QueryEntityProcessor.firstCharToUpperCase(name);
        }
        return QueryEntityProcessor.firstCharToLowerCase(name);
    }

    private String buildTablesClass(String entityClass, String schema, String tableName, Map<String, String> propertyAndColumns, List<String> defaultColumns, String tablesNameStyle, String tablesDefSuffix, String realGenPackage, boolean allInTables) {
        String tableDef = tableDefTemplate.replace("@entityClass", entityClass).replace("@schema", schema).replace("@tableField", QueryEntityProcessor.buildName(entityClass, tablesNameStyle) + (tablesDefSuffix != null ? tablesDefSuffix.trim() : "")).replace("@tableName", tableName);
        StringBuilder queryColumns = new StringBuilder();
        propertyAndColumns.forEach((property, column) -> queryColumns.append(columnsTemplate.substring(allInTables ? 0 : 4).replace("@property", QueryEntityProcessor.buildName(property, tablesNameStyle)).replace("@columnName", (CharSequence)column)));
        StringJoiner allColumns = new StringJoiner(", ");
        propertyAndColumns.forEach((property, column) -> allColumns.add(QueryEntityProcessor.buildName(property, tablesNameStyle)));
        String allColumnsString = allColumnsTemplate;
        StringJoiner defaultColumnStringJoiner = new StringJoiner(", ");
        propertyAndColumns.forEach((property, column) -> {
            if (defaultColumns.contains(column)) {
                defaultColumnStringJoiner.add(QueryEntityProcessor.buildName(property, tablesNameStyle));
            }
        });
        String defaultColumnsString = defaultColumnsTemplate.replace("@allColumns", defaultColumnStringJoiner.toString()).replace("DEFAULT_COLUMNS", QueryEntityProcessor.buildName("defaultColumns", tablesNameStyle));
        String tableClass = allInTables ? allInTableEntityClassTemplate.replace("@entityClass", entityClass).replace("@queryColumns", queryColumns).replace("@defaultColumns", defaultColumnsString).replace("@allColumns", allColumnsString) : singleEntityClassTemplate.replace("@package", realGenPackage).replace("@entityClass", entityClass).replace("@selfDef", tableDef.replace("\n\n", "") + "\n").replace("@queryColumns", queryColumns).replace("@defaultColumns", "\n" + defaultColumnsString.substring(5)).replace("@allColumns", allColumnsString.substring(4));
        return allInTables ? tableDef + tableClass : tableClass;
    }

    private void genTablesClass(String genBasePath, String genPackageName, String className, String classContent) {
        String genContent = classTableTemplate.replace("@package", genPackageName).replace("@classesInfo", classContent).replace("@tablesClassName", className);
        this.genClass(genBasePath, genPackageName, className, genContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void genClass(String genBasePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (genBasePath == null || genBasePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (QueryEntityProcessor.isAbsolutePath(genBasePath)) {
                realPath = genBasePath;
            } else {
                String projectRootPath = this.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, genBasePath).getAbsolutePath();
            }
            boolean fromTestSource = this.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by mybatis-flex processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void genMapperClass(String genBasePath, String genPackageName, String entityClass, String baseMapperClass, String entityName) {
        entityName = entityClass.substring(entityClass.lastIndexOf(".") + 1);
        String baseMapperClzName = baseMapperClass.substring(baseMapperClass.lastIndexOf(".") + 1);
        String genContent = mapperTemplate.replace("@package", genPackageName).replace("@entityClass", entityClass).replace("@entityName", entityName).replace("@baseMapperClass", baseMapperClass).replace("@baseMapperClzName", baseMapperClzName);
        String mapperClassName = entityName + "Mapper";
        this.genClass(genBasePath, genPackageName, mapperClassName, genContent);
    }

    private void printMessage(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
        System.out.println(message);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return string;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(Table.class.getCanonicalName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getProjectRootPath(file, count);
    }

    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getProjectRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getProjectRootPath(file.getParentFile(), --count);
    }

    private String getModuleRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getModuleRootPath(file, count);
    }

    private String getModuleRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getModuleRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getModuleRootPath(file.getParentFile(), --count);
    }
}

