/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldWrapper {
    public static Map<Class<?>, Map<String, FieldWrapper>> cache = new ConcurrentHashMap();
    private Class<?> fieldType;
    private Class<?> mappingType;
    private Method setterMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldWrapper of(Class<?> clazz, String fieldName) {
        FieldWrapper fieldWrapper;
        Map<String, FieldWrapper> wrapperMap = cache.get(clazz);
        if (wrapperMap == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                if (wrapperMap == null) {
                    wrapperMap = new ConcurrentHashMap<String, FieldWrapper>();
                    cache.put(clazz, wrapperMap);
                }
            }
        }
        if ((fieldWrapper = wrapperMap.get(fieldName)) == null) {
            Class<?> clazz3 = clazz;
            synchronized (clazz3) {
                fieldWrapper = wrapperMap.get(fieldName);
                if (fieldWrapper == null) {
                    Field findField = ClassUtil.getFirstField(clazz, field -> field.getName().equals(fieldName));
                    if (findField == null) {
                        throw new IllegalStateException("Can not find field \"" + fieldName + "\" in class: " + clazz);
                    }
                    Method setter = ClassUtil.getFirstMethod(clazz, method -> method.getParameterCount() == 1 && Modifier.isPublic(method.getModifiers()) && method.getName().equals("set" + StringUtil.firstCharToUpperCase(fieldName)));
                    if (setter == null) {
                        throw new IllegalStateException("Can not find method \"set" + StringUtil.firstCharToUpperCase(fieldName) + "\" in class: " + clazz);
                    }
                    fieldWrapper = new FieldWrapper();
                    fieldWrapper.fieldType = findField.getType();
                    fieldWrapper.mappingType = FieldWrapper.parseMappingType(findField);
                    fieldWrapper.setterMethod = setter;
                    wrapperMap.put(fieldName, fieldWrapper);
                }
            }
        }
        return fieldWrapper;
    }

    private static Class<?> parseMappingType(Field field) {
        Type genericType;
        Class<?> fieldType = field.getType();
        if (Collection.class.isAssignableFrom(fieldType) && (genericType = field.getGenericType()) instanceof ParameterizedType) {
            Type actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return (Class)actualTypeArgument;
        }
        if (fieldType.isArray()) {
            return field.getType().getComponentType();
        }
        return fieldType;
    }

    public void set(Object value, Object to) {
        try {
            this.setterMethod.invoke(to, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public Class<?> getMappingType() {
        return this.mappingType;
    }
}

