/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.List;

public interface LimitOffsetProcessor {
    public static final LimitOffsetProcessor MYSQL = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" LIMIT ").append(limitOffset).append(", ").append(limitRows);
        } else if (limitRows != null) {
            sql.append(" LIMIT ").append(limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor POSTGRESQL = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" LIMIT ").append(limitRows).append(" OFFSET ").append(limitOffset);
        } else if (limitRows != null) {
            sql.append(" LIMIT ").append(limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor DERBY = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" OFFSET ").append(limitOffset).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        } else if (limitRows != null) {
            sql.append(" OFFSET ").append(0).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        }
        return sql;
    };
    public static final LimitOffsetProcessor SQLSERVER = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" OFFSET ").append(limitOffset).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
        } else if (limitRows != null) {
            List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
            if (CollectionUtil.isNotEmpty(orderBys)) {
                sql.append(" OFFSET ").append(0).append(" ROWS FETCH NEXT ").append(limitRows).append(" ROWS ONLY");
            } else {
                sql.insert(6, " TOP " + limitRows);
            }
        }
        return sql;
    };
    public static final LimitOffsetProcessor INFORMIX = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.insert(6, " SKIP " + limitOffset + " FIRST " + limitRows);
        } else if (limitRows != null) {
            sql.insert(6, " FIRST " + limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor FIREBIRD = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.append(" ROWS ").append(limitOffset).append(" TO ").append(limitOffset + limitRows);
        } else if (limitRows != null) {
            sql.insert(6, " FIRST " + limitRows);
        }
        return sql;
    };
    public static final LimitOffsetProcessor ORACLE = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null) {
            if (limitOffset == null) {
                limitOffset = 0;
            }
            StringBuilder newSql = new StringBuilder("SELECT * FROM (SELECT TEMP_DATAS.*, ROWNUM RN FROM (");
            newSql.append((CharSequence)sql);
            newSql.append(") TEMP_DATAS WHERE ROWNUM <= ").append(limitOffset + limitRows).append(") WHERE RN > ").append(limitOffset);
            return newSql;
        }
        return sql;
    };
    public static final LimitOffsetProcessor SYBASE = (sql, queryWrapper, limitRows, limitOffset) -> {
        if (limitRows != null && limitOffset != null) {
            sql.insert(6, " TOP " + limitRows + " START AT " + (limitOffset + 1));
        } else if (limitRows != null) {
            sql.insert(6, " TOP " + limitRows);
        }
        return sql;
    };

    public StringBuilder process(StringBuilder var1, QueryWrapper var2, Integer var3, Integer var4);
}

