/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.DiskInstanceView;
import com.microsoft.azure.management.compute.DiskVolumeEncryptionMonitor;
import com.microsoft.azure.management.compute.EncryptionStatus;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class WindowsVolumeNoAADEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineInner virtualMachine;

    WindowsVolumeNoAADEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.WINDOWS;
    }

    @Override
    public String progressMessage() {
        return String.format("OSDisk: %s DataDisk: %s", new Object[]{this.osDiskStatus(), this.dataDiskStatus()});
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return EncryptionStatus.UNKNOWN;
        }
        for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            if (diskInstanceView.encryptionSettings() == null) continue;
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                EncryptionStatus encryptionStatus = WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code());
                if (encryptionStatus == null) continue;
                return encryptionStatus;
            }
        }
        return EncryptionStatus.UNKNOWN;
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return EncryptionStatus.UNKNOWN;
        }
        HashSet<EncryptionStatus> encryptStatuses = new HashSet<EncryptionStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            if (diskInstanceView.encryptionSettings() != null) continue;
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                EncryptionStatus encryptionStatus = WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code());
                if (encryptionStatus == null) continue;
                encryptStatuses.add(encryptionStatus);
                continue block0;
            }
        }
        if (encryptStatuses.isEmpty()) {
            return EncryptionStatus.UNKNOWN;
        }
        if (encryptStatuses.size() == 1) {
            return (EncryptionStatus)((Object)encryptStatuses.iterator().next());
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.UNKNOWN)) {
            return EncryptionStatus.UNKNOWN;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.NOT_MOUNTED)) {
            return EncryptionStatus.NOT_MOUNTED;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.ENCRYPTION_INPROGRESS)) {
            return EncryptionStatus.ENCRYPTION_INPROGRESS;
        }
        if (encryptStatuses.contains((Object)EncryptionStatus.VM_RESTART_PENDING)) {
            return EncryptionStatus.VM_RESTART_PENDING;
        }
        return EncryptionStatus.UNKNOWN;
    }

    @Override
    @Beta
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        if (this.virtualMachine.instanceView() == null || this.virtualMachine.instanceView().disks() == null) {
            return new HashMap<String, InstanceViewStatus>();
        }
        HashMap<String, InstanceViewStatus> div = new HashMap<String, InstanceViewStatus>();
        block0: for (DiskInstanceView diskInstanceView : this.virtualMachine.instanceView().disks()) {
            for (InstanceViewStatus status : diskInstanceView.statuses()) {
                if (WindowsVolumeNoAADEncryptionMonitorImpl.encryptionStatusFromCode(status.code()) == null) continue;
                div.put(diskInstanceView.name(), status);
                continue block0;
            }
        }
        return div;
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().toBlocking().last();
    }

    @Override
    public Observable<DiskVolumeEncryptionMonitor> refreshAsync() {
        final WindowsVolumeNoAADEncryptionMonitorImpl self = this;
        return this.retrieveVirtualMachineAsync().flatMap((Func1)new Func1<VirtualMachineInner, Observable<DiskVolumeEncryptionMonitor>>(){

            public Observable<DiskVolumeEncryptionMonitor> call(VirtualMachineInner virtualMachine) {
                self.virtualMachine = virtualMachine;
                return Observable.just((Object)self);
            }
        });
    }

    private Observable<VirtualMachineInner> retrieveVirtualMachineAsync() {
        return ((ComputeManagementClientImpl)((Object)this.computeManager.inner())).virtualMachines().getByResourceGroupAsync(this.rgName, this.vmName, InstanceViewTypes.INSTANCE_VIEW).flatMap((Func1)new Func1<VirtualMachineInner, Observable<VirtualMachineInner>>(){

            public Observable<VirtualMachineInner> call(VirtualMachineInner virtualMachine) {
                if (virtualMachine == null) {
                    return Observable.error((Throwable)new Exception(String.format("VM with name '%s' not found (resource group '%s')", WindowsVolumeNoAADEncryptionMonitorImpl.this.vmName, WindowsVolumeNoAADEncryptionMonitorImpl.this.rgName)));
                }
                return Observable.just((Object)((Object)virtualMachine));
            }
        });
    }

    private static EncryptionStatus encryptionStatusFromCode(String code) {
        if (code != null && code.toLowerCase().startsWith("encryptionstate")) {
            String[] parts = code.split("/", 2);
            if (parts.length != 2) {
                return EncryptionStatus.UNKNOWN;
            }
            return EncryptionStatus.fromString(parts[1]);
        }
        return null;
    }
}

