/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImageInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineExtensionImagesInner {
    private VirtualMachineExtensionImagesService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineExtensionImagesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineExtensionImagesService)retrofit.create(VirtualMachineExtensionImagesService.class);
        this.client = client;
    }

    public VirtualMachineExtensionImageInner get(String location, String publisherName, String type, String version) {
        return (VirtualMachineExtensionImageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(location, publisherName, type, version).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineExtensionImageInner> getAsync(String location, String publisherName, String type, String version, ServiceCallback<VirtualMachineExtensionImageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(location, publisherName, type, version), serviceCallback);
    }

    public Observable<VirtualMachineExtensionImageInner> getAsync(String location, String publisherName, String type, String version) {
        return this.getWithServiceResponseAsync(location, publisherName, type, version).map((Func1)new Func1<ServiceResponse<VirtualMachineExtensionImageInner>, VirtualMachineExtensionImageInner>(){

            public VirtualMachineExtensionImageInner call(ServiceResponse<VirtualMachineExtensionImageInner> response) {
                return (VirtualMachineExtensionImageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineExtensionImageInner>> getWithServiceResponseAsync(String location, String publisherName, String type, String version) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.get(location, publisherName, type, version, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineExtensionImageInner>>>(){

            public Observable<ServiceResponse<VirtualMachineExtensionImageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineExtensionImagesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineExtensionImageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineExtensionImageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineExtensionImageInner> listTypes(String location, String publisherName) {
        return (List)((ServiceResponse)this.listTypesWithServiceResponseAsync(location, publisherName).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineExtensionImageInner>> listTypesAsync(String location, String publisherName, ServiceCallback<List<VirtualMachineExtensionImageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listTypesWithServiceResponseAsync(location, publisherName), serviceCallback);
    }

    public Observable<List<VirtualMachineExtensionImageInner>> listTypesAsync(String location, String publisherName) {
        return this.listTypesWithServiceResponseAsync(location, publisherName).map((Func1)new Func1<ServiceResponse<List<VirtualMachineExtensionImageInner>>, List<VirtualMachineExtensionImageInner>>(){

            public List<VirtualMachineExtensionImageInner> call(ServiceResponse<List<VirtualMachineExtensionImageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> listTypesWithServiceResponseAsync(String location, String publisherName) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listTypes(location, publisherName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineExtensionImagesInner.this.listTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineExtensionImageInner>> listTypesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineExtensionImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineExtensionImageInner> listVersions(String location, String publisherName, String type) {
        return (List)((ServiceResponse)this.listVersionsWithServiceResponseAsync(location, publisherName, type).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type, ServiceCallback<List<VirtualMachineExtensionImageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listVersionsWithServiceResponseAsync(location, publisherName, type), serviceCallback);
    }

    public Observable<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type) {
        return this.listVersionsWithServiceResponseAsync(location, publisherName, type).map((Func1)new Func1<ServiceResponse<List<VirtualMachineExtensionImageInner>>, List<VirtualMachineExtensionImageInner>>(){

            public List<VirtualMachineExtensionImageInner> call(ServiceResponse<List<VirtualMachineExtensionImageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> listVersionsWithServiceResponseAsync(String location, String publisherName, String type) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String filter = null;
        Integer top = null;
        String orderby = null;
        return this.service.listVersions(location, publisherName, type, this.client.subscriptionId(), filter, top, orderby, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineExtensionImagesInner.this.listVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<VirtualMachineExtensionImageInner> listVersions(String location, String publisherName, String type, String filter, Integer top, String orderby) {
        return (List)((ServiceResponse)this.listVersionsWithServiceResponseAsync(location, publisherName, type, filter, top, orderby).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type, String filter, Integer top, String orderby, ServiceCallback<List<VirtualMachineExtensionImageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listVersionsWithServiceResponseAsync(location, publisherName, type, filter, top, orderby), serviceCallback);
    }

    public Observable<List<VirtualMachineExtensionImageInner>> listVersionsAsync(String location, String publisherName, String type, String filter, Integer top, String orderby) {
        return this.listVersionsWithServiceResponseAsync(location, publisherName, type, filter, top, orderby).map((Func1)new Func1<ServiceResponse<List<VirtualMachineExtensionImageInner>>, List<VirtualMachineExtensionImageInner>>(){

            public List<VirtualMachineExtensionImageInner> call(ServiceResponse<List<VirtualMachineExtensionImageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> listVersionsWithServiceResponseAsync(String location, String publisherName, String type, String filter, Integer top, String orderby) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (publisherName == null) {
            throw new IllegalArgumentException("Parameter publisherName is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.listVersions(location, publisherName, type, this.client.subscriptionId(), filter, top, orderby, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineExtensionImageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineExtensionImagesInner.this.listVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<VirtualMachineExtensionImageInner>> listVersionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<VirtualMachineExtensionImageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineExtensionImagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineExtensionImages get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions/{version}")
        public Observable<Response<ResponseBody>> get(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="type") String var3, @Path(value="version") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineExtensionImages listTypes"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types")
        public Observable<Response<ResponseBody>> listTypes(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineExtensionImages listVersions"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmextension/types/{type}/versions")
        public Observable<Response<ResponseBody>> listVersions(@Path(value="location") String var1, @Path(value="publisherName") String var2, @Path(value="type") String var3, @Path(value="subscriptionId") String var4, @Query(value="$filter") String var5, @Query(value="$top") Integer var6, @Query(value="$orderby") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);
    }
}

