/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmEnum;
import tss.TpmUnion;
import tss.tpm.TPM2B_DIGEST_KEYEDHASH;
import tss.tpm.TPM2B_DIGEST_SYMCIPHER;
import tss.tpm.TPM2B_ECC_PARAMETER;
import tss.tpm.TPM2B_PRIVATE_KEY_RSA;
import tss.tpm.TPM2B_PRIVATE_VENDOR_SPECIFIC;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPM2B_SENSITIVE_DATA;
import tss.tpm.TPM2B_SYM_KEY;
import tss.tpm.TPML_ACT_DATA;
import tss.tpm.TPML_ALG_PROPERTY;
import tss.tpm.TPML_CC;
import tss.tpm.TPML_CCA;
import tss.tpm.TPML_ECC_CURVE;
import tss.tpm.TPML_HANDLE;
import tss.tpm.TPML_PCR_SELECTION;
import tss.tpm.TPML_TAGGED_PCR_PROPERTY;
import tss.tpm.TPML_TAGGED_POLICY;
import tss.tpm.TPML_TAGGED_TPM_PROPERTY;
import tss.tpm.TPMS_AES_SYM_DETAILS;
import tss.tpm.TPMS_ANY_SYM_DETAILS;
import tss.tpm.TPMS_ASYM_PARMS;
import tss.tpm.TPMS_CAMELLIA_SYM_DETAILS;
import tss.tpm.TPMS_CERTIFY_INFO;
import tss.tpm.TPMS_COMMAND_AUDIT_INFO;
import tss.tpm.TPMS_CREATION_INFO;
import tss.tpm.TPMS_DERIVE;
import tss.tpm.TPMS_ECC_PARMS;
import tss.tpm.TPMS_ECC_POINT;
import tss.tpm.TPMS_ENC_SCHEME_OAEP;
import tss.tpm.TPMS_ENC_SCHEME_RSAES;
import tss.tpm.TPMS_KDF_SCHEME_KDF1_SP800_108;
import tss.tpm.TPMS_KDF_SCHEME_KDF1_SP800_56A;
import tss.tpm.TPMS_KDF_SCHEME_KDF2;
import tss.tpm.TPMS_KDF_SCHEME_MGF1;
import tss.tpm.TPMS_KEYEDHASH_PARMS;
import tss.tpm.TPMS_KEY_SCHEME_ECDH;
import tss.tpm.TPMS_KEY_SCHEME_ECMQV;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_NULL_KDF_SCHEME;
import tss.tpm.TPMS_NULL_SCHEME_KEYEDHASH;
import tss.tpm.TPMS_NULL_SIGNATURE;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_NULL_SYM_DETAILS;
import tss.tpm.TPMS_NV_CERTIFY_INFO;
import tss.tpm.TPMS_NV_DIGEST_CERTIFY_INFO;
import tss.tpm.TPMS_QUOTE_INFO;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SCHEME_HASH;
import tss.tpm.TPMS_SCHEME_HMAC;
import tss.tpm.TPMS_SCHEME_XOR;
import tss.tpm.TPMS_SESSION_AUDIT_INFO;
import tss.tpm.TPMS_SIGNATURE_ECDAA;
import tss.tpm.TPMS_SIGNATURE_ECDSA;
import tss.tpm.TPMS_SIGNATURE_ECSCHNORR;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIGNATURE_SM2;
import tss.tpm.TPMS_SIG_SCHEME_ECDAA;
import tss.tpm.TPMS_SIG_SCHEME_ECDSA;
import tss.tpm.TPMS_SIG_SCHEME_ECSCHNORR;
import tss.tpm.TPMS_SIG_SCHEME_RSAPSS;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_SM2;
import tss.tpm.TPMS_SM4_SYM_DETAILS;
import tss.tpm.TPMS_SYMCIPHER_PARMS;
import tss.tpm.TPMS_TDES_SYM_DETAILS;
import tss.tpm.TPMS_TIME_ATTEST_INFO;
import tss.tpm.TPMS_XOR_SYM_DETAILS;
import tss.tpm.TPMT_HA;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_CAP;
import tss.tpm.TPM_ST;

class UnionFactory {
    UnionFactory() {
    }

    public static <U extends TpmUnion, S extends TpmEnum<S>> U create(String unionType, S selector) {
        if (unionType == "TPMU_CAPABILITIES") {
            switch (((TPM_CAP)selector).asEnum()) {
                case ALGS: {
                    return (U)new TPML_ALG_PROPERTY();
                }
                case HANDLES: {
                    return (U)new TPML_HANDLE();
                }
                case COMMANDS: {
                    return (U)new TPML_CCA();
                }
                case PP_COMMANDS: {
                    return (U)new TPML_CC();
                }
                case AUDIT_COMMANDS: {
                    return (U)new TPML_CC();
                }
                case PCRS: {
                    return (U)new TPML_PCR_SELECTION();
                }
                case TPM_PROPERTIES: {
                    return (U)new TPML_TAGGED_TPM_PROPERTY();
                }
                case PCR_PROPERTIES: {
                    return (U)new TPML_TAGGED_PCR_PROPERTY();
                }
                case ECC_CURVES: {
                    return (U)new TPML_ECC_CURVE();
                }
                case AUTH_POLICIES: {
                    return (U)new TPML_TAGGED_POLICY();
                }
                case ACT: {
                    return (U)new TPML_ACT_DATA();
                }
            }
        } else if (unionType == "TPMU_ATTEST") {
            switch (((TPM_ST)selector).asEnum()) {
                case ATTEST_CERTIFY: {
                    return (U)new TPMS_CERTIFY_INFO();
                }
                case ATTEST_CREATION: {
                    return (U)new TPMS_CREATION_INFO();
                }
                case ATTEST_QUOTE: {
                    return (U)new TPMS_QUOTE_INFO();
                }
                case ATTEST_COMMAND_AUDIT: {
                    return (U)new TPMS_COMMAND_AUDIT_INFO();
                }
                case ATTEST_SESSION_AUDIT: {
                    return (U)new TPMS_SESSION_AUDIT_INFO();
                }
                case ATTEST_TIME: {
                    return (U)new TPMS_TIME_ATTEST_INFO();
                }
                case ATTEST_NV: {
                    return (U)new TPMS_NV_CERTIFY_INFO();
                }
                case ATTEST_NV_DIGEST: {
                    return (U)new TPMS_NV_DIGEST_CERTIFY_INFO();
                }
            }
        } else if (unionType == "TPMU_SYM_DETAILS") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case TDES: {
                    return (U)new TPMS_TDES_SYM_DETAILS();
                }
                case AES: {
                    return (U)new TPMS_AES_SYM_DETAILS();
                }
                case SM4: {
                    return (U)new TPMS_SM4_SYM_DETAILS();
                }
                case CAMELLIA: {
                    return (U)new TPMS_CAMELLIA_SYM_DETAILS();
                }
                case ANY: {
                    return (U)new TPMS_ANY_SYM_DETAILS();
                }
                case XOR: {
                    return (U)new TPMS_XOR_SYM_DETAILS();
                }
                case NULL: {
                    return (U)new TPMS_NULL_SYM_DETAILS();
                }
            }
        } else if (unionType == "TPMU_SENSITIVE_CREATE") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case ANY: {
                    return null;
                }
                case ANY2: {
                    return (U)new TPMS_DERIVE();
                }
            }
        } else if (unionType == "TPMU_SCHEME_KEYEDHASH") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case HMAC: {
                    return (U)new TPMS_SCHEME_HMAC();
                }
                case XOR: {
                    return (U)new TPMS_SCHEME_XOR();
                }
                case NULL: {
                    return (U)new TPMS_NULL_SCHEME_KEYEDHASH();
                }
            }
        } else if (unionType == "TPMU_SIG_SCHEME") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case RSASSA: {
                    return (U)new TPMS_SIG_SCHEME_RSASSA();
                }
                case RSAPSS: {
                    return (U)new TPMS_SIG_SCHEME_RSAPSS();
                }
                case ECDSA: {
                    return (U)new TPMS_SIG_SCHEME_ECDSA();
                }
                case ECDAA: {
                    return (U)new TPMS_SIG_SCHEME_ECDAA();
                }
                case SM2: {
                    return (U)new TPMS_SIG_SCHEME_SM2();
                }
                case ECSCHNORR: {
                    return (U)new TPMS_SIG_SCHEME_ECSCHNORR();
                }
                case HMAC: {
                    return (U)new TPMS_SCHEME_HMAC();
                }
                case ANY: {
                    return (U)new TPMS_SCHEME_HASH();
                }
                case NULL: {
                    return (U)new TPMS_NULL_SIG_SCHEME();
                }
            }
        } else if (unionType == "TPMU_KDF_SCHEME") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case MGF1: {
                    return (U)new TPMS_KDF_SCHEME_MGF1();
                }
                case KDF1_SP800_56A: {
                    return (U)new TPMS_KDF_SCHEME_KDF1_SP800_56A();
                }
                case KDF2: {
                    return (U)new TPMS_KDF_SCHEME_KDF2();
                }
                case KDF1_SP800_108: {
                    return (U)new TPMS_KDF_SCHEME_KDF1_SP800_108();
                }
                case ANY: {
                    return (U)new TPMS_SCHEME_HASH();
                }
                case NULL: {
                    return (U)new TPMS_NULL_KDF_SCHEME();
                }
            }
        } else if (unionType == "TPMU_ASYM_SCHEME") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case ECDH: {
                    return (U)new TPMS_KEY_SCHEME_ECDH();
                }
                case ECMQV: {
                    return (U)new TPMS_KEY_SCHEME_ECMQV();
                }
                case RSASSA: {
                    return (U)new TPMS_SIG_SCHEME_RSASSA();
                }
                case RSAPSS: {
                    return (U)new TPMS_SIG_SCHEME_RSAPSS();
                }
                case ECDSA: {
                    return (U)new TPMS_SIG_SCHEME_ECDSA();
                }
                case ECDAA: {
                    return (U)new TPMS_SIG_SCHEME_ECDAA();
                }
                case SM2: {
                    return (U)new TPMS_SIG_SCHEME_SM2();
                }
                case ECSCHNORR: {
                    return (U)new TPMS_SIG_SCHEME_ECSCHNORR();
                }
                case RSAES: {
                    return (U)new TPMS_ENC_SCHEME_RSAES();
                }
                case OAEP: {
                    return (U)new TPMS_ENC_SCHEME_OAEP();
                }
                case ANY: {
                    return (U)new TPMS_SCHEME_HASH();
                }
                case NULL: {
                    return (U)new TPMS_NULL_ASYM_SCHEME();
                }
            }
        } else if (unionType == "TPMU_SIGNATURE") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case RSASSA: {
                    return (U)new TPMS_SIGNATURE_RSASSA();
                }
                case RSAPSS: {
                    return (U)new TPMS_SIGNATURE_RSAPSS();
                }
                case ECDSA: {
                    return (U)new TPMS_SIGNATURE_ECDSA();
                }
                case ECDAA: {
                    return (U)new TPMS_SIGNATURE_ECDAA();
                }
                case SM2: {
                    return (U)new TPMS_SIGNATURE_SM2();
                }
                case ECSCHNORR: {
                    return (U)new TPMS_SIGNATURE_ECSCHNORR();
                }
                case HMAC: {
                    return (U)new TPMT_HA();
                }
                case ANY: {
                    return (U)new TPMS_SCHEME_HASH();
                }
                case NULL: {
                    return (U)new TPMS_NULL_SIGNATURE();
                }
            }
        } else if (unionType == "TPMU_PUBLIC_ID") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case KEYEDHASH: {
                    return (U)new TPM2B_DIGEST_KEYEDHASH();
                }
                case SYMCIPHER: {
                    return (U)new TPM2B_DIGEST_SYMCIPHER();
                }
                case RSA: {
                    return (U)new TPM2B_PUBLIC_KEY_RSA();
                }
                case ECC: {
                    return (U)new TPMS_ECC_POINT();
                }
                case ANY: {
                    return (U)new TPMS_DERIVE();
                }
            }
        } else if (unionType == "TPMU_PUBLIC_PARMS") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case KEYEDHASH: {
                    return (U)new TPMS_KEYEDHASH_PARMS();
                }
                case SYMCIPHER: {
                    return (U)new TPMS_SYMCIPHER_PARMS();
                }
                case RSA: {
                    return (U)new TPMS_RSA_PARMS();
                }
                case ECC: {
                    return (U)new TPMS_ECC_PARMS();
                }
                case ANY: {
                    return (U)new TPMS_ASYM_PARMS();
                }
            }
        } else if (unionType == "TPMU_SENSITIVE_COMPOSITE") {
            switch (((TPM_ALG_ID)selector).asEnum()) {
                case RSA: {
                    return (U)new TPM2B_PRIVATE_KEY_RSA();
                }
                case ECC: {
                    return (U)new TPM2B_ECC_PARAMETER();
                }
                case KEYEDHASH: {
                    return (U)new TPM2B_SENSITIVE_DATA();
                }
                case SYMCIPHER: {
                    return (U)new TPM2B_SYM_KEY();
                }
                case ANY: {
                    return (U)new TPM2B_PRIVATE_VENDOR_SPECIFIC();
                }
            }
        } else {
            throw new RuntimeException("UnionFactory::Create(): Unknown union type " + unionType);
        }
        throw new RuntimeException("Unknown selector value " + selector.toString() + " for union " + unionType);
    }
}

