/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.TpmBuffer;
import tss.TpmStructure;
import tss.TpmStructurePrinter;
import tss.tpm.TPM2B_PRIVATE;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SENSITIVE;

public class TssObject
extends TpmStructure {
    public TPMT_PUBLIC Public;
    public TPMT_SENSITIVE Sensitive;
    public TPM2B_PRIVATE Private;

    public TssObject() {
    }

    public TssObject(TPMT_PUBLIC _Public, TPMT_SENSITIVE _Sensitive, TPM2B_PRIVATE _Private) {
        this.Public = _Public;
        this.Sensitive = _Sensitive;
        this.Private = _Private;
    }

    @Override
    public void toTpm(TpmBuffer buf) {
        this.Public.toTpm(buf);
        this.Sensitive.toTpm(buf);
        this.Private.toTpm(buf);
    }

    @Override
    public void initFromTpm(TpmBuffer buf) {
        this.Public = TPMT_PUBLIC.fromTpm(buf);
        this.Sensitive = TPMT_SENSITIVE.fromTpm(buf);
        this.Private = TPM2B_PRIVATE.fromTpm(buf);
    }

    public byte[] toTpm() {
        return this.toBytes();
    }

    public static TssObject fromBytes(byte[] byteBuf) {
        return new TpmBuffer(byteBuf).createObj(TssObject.class);
    }

    public static TssObject fromTpm(byte[] byteBuf) {
        return TssObject.fromBytes(byteBuf);
    }

    public static TssObject fromTpm(TpmBuffer buf) {
        return buf.createObj(TssObject.class);
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TssObject");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "TPMT_PUBLIC", "Public", this.Public);
        _p.add(d, "TPMT_SENSITIVE", "Sensitive", this.Sensitive);
        _p.add(d, "TPM2B_PRIVATE", "Private", this.Private);
    }
}

